/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.OrderBy;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder<T, ID>
extends StatementBuilder<T, ID> {
    private final FieldType idField;
    private FieldType[] resultFieldTypes;
    private boolean distinct;
    private boolean selectIdColumn = true;
    private List<String> selectColumnList;
    private List<String> selectRawList;
    private List<OrderBy> orderByList;
    private String orderByRaw;
    private ArgumentHolder[] orderByArgs;
    private List<String> groupByList;
    private String groupByRaw;
    private boolean isInnerQuery;
    private boolean isCountOfQuery;
    private String having;
    private Long limit;
    private Long offset;
    private List<JoinInfo> joinList;

    public QueryBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao) {
        super(databaseType, tableInfo, dao, StatementBuilder.StatementType.SELECT);
        this.idField = tableInfo.getIdField();
    }

    void enableInnerQuery() {
        this.isInnerQuery = true;
    }

    int getSelectColumnCount() {
        if (this.isCountOfQuery) {
            return 1;
        }
        if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            return this.selectRawList.size();
        }
        if (this.selectColumnList == null) {
            return 0;
        }
        return this.selectColumnList.size();
    }

    List<String> getSelectColumns() {
        if (this.isCountOfQuery) {
            return Collections.singletonList("COUNT(*)");
        }
        if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            return this.selectRawList;
        }
        if (this.selectColumnList == null) {
            return Collections.emptyList();
        }
        return this.selectColumnList;
    }

    public PreparedQuery<T> prepare() throws SQLException {
        return super.prepareStatement(this.limit);
    }

    public QueryBuilder<T, ID> selectColumns(String ... columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectColumns(Iterable<String> columns) {
        if (this.selectColumnList == null) {
            this.selectColumnList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.addSelectColumnToList(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> selectRaw(String ... columns) {
        if (this.selectRawList == null) {
            this.selectRawList = new ArrayList<String>();
        }
        for (String column : columns) {
            this.selectRawList.add(column);
        }
        return this;
    }

    public QueryBuilder<T, ID> groupBy(String columnName) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't groupBy foreign colletion field: " + columnName);
        }
        if (this.groupByList == null) {
            this.groupByList = new ArrayList<String>();
        }
        this.groupByList.add(columnName);
        this.selectIdColumn = false;
        return this;
    }

    public QueryBuilder<T, ID> groupByRaw(String rawSql) {
        this.groupByRaw = rawSql;
        return this;
    }

    public QueryBuilder<T, ID> orderBy(String columnName, boolean ascending) {
        FieldType fieldType = this.verifyColumnName(columnName);
        if (fieldType.isForeignCollection()) {
            throw new IllegalArgumentException("Can't orderBy foreign colletion field: " + columnName);
        }
        if (this.orderByList == null) {
            this.orderByList = new ArrayList<OrderBy>();
        }
        this.orderByList.add(new OrderBy(columnName, ascending));
        return this;
    }

    public QueryBuilder<T, ID> orderByRaw(String rawSql) {
        return this.orderByRaw(rawSql, null);
    }

    public QueryBuilder<T, ID> orderByRaw(String rawSql, ArgumentHolder ... args) {
        this.orderByRaw = rawSql;
        this.orderByArgs = args;
        return this;
    }

    public QueryBuilder<T, ID> distinct() {
        this.distinct = true;
        this.selectIdColumn = false;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> limit(int maxRows) {
        return this.limit(Long.valueOf(maxRows));
    }

    public QueryBuilder<T, ID> limit(Long maxRows) {
        this.limit = maxRows;
        return this;
    }

    @Deprecated
    public QueryBuilder<T, ID> offset(int startRow) throws SQLException {
        return this.offset(Long.valueOf(startRow));
    }

    public QueryBuilder<T, ID> offset(Long startRow) throws SQLException {
        if (this.databaseType.isOffsetSqlSupported()) {
            this.offset = startRow;
            return this;
        }
        throw new SQLException("Offset is not supported by this database");
    }

    public QueryBuilder<T, ID> setCountOf(boolean countOf) {
        this.isCountOfQuery = countOf;
        return this;
    }

    public QueryBuilder<T, ID> having(String having) {
        this.having = having;
        return this;
    }

    public QueryBuilder<T, ID> join(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo("INNER", joinedQueryBuilder, StatementBuilder.WhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> joinOr(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo("INNER", joinedQueryBuilder, StatementBuilder.WhereOperation.OR);
        return this;
    }

    public QueryBuilder<T, ID> leftJoin(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo("LEFT", joinedQueryBuilder, StatementBuilder.WhereOperation.AND);
        return this;
    }

    public QueryBuilder<T, ID> leftJoinOr(QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        this.addJoinInfo("LEFT", joinedQueryBuilder, StatementBuilder.WhereOperation.OR);
        return this;
    }

    public List<T> query() throws SQLException {
        return this.dao.query(this.prepare());
    }

    public GenericRawResults<String[]> queryRaw() throws SQLException {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]);
    }

    public T queryForFirst() throws SQLException {
        return this.dao.queryForFirst(this.prepare());
    }

    public String[] queryRawFirst() throws SQLException {
        return this.dao.queryRaw(this.prepareStatementString(), new String[0]).getFirstResult();
    }

    public CloseableIterator<T> iterator() throws SQLException {
        return this.dao.iterator(this.prepare());
    }

    public long countOf() throws SQLException {
        this.setCountOf(true);
        return this.dao.countOf(this.prepare());
    }

    @Override
    @Deprecated
    public void clear() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.distinct = false;
        this.selectIdColumn = true;
        this.selectColumnList = null;
        this.selectRawList = null;
        this.orderByList = null;
        this.orderByRaw = null;
        this.groupByList = null;
        this.groupByRaw = null;
        this.isInnerQuery = false;
        this.isCountOfQuery = false;
        this.having = null;
        this.limit = null;
        this.offset = null;
        if (this.joinList != null) {
            this.joinList.clear();
            this.joinList = null;
        }
        this.addTableName = false;
    }

    @Override
    protected void appendStatementStart(StringBuilder sb, List<ArgumentHolder> argList) {
        if (this.joinList == null) {
            this.setAddTableName(false);
        } else {
            this.setAddTableName(true);
        }
        sb.append("SELECT ");
        if (this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        if (this.isCountOfQuery) {
            this.type = StatementBuilder.StatementType.SELECT_LONG;
            sb.append("COUNT(*) ");
        } else if (this.selectRawList != null && !this.selectRawList.isEmpty()) {
            this.type = StatementBuilder.StatementType.SELECT_RAW;
            this.appendSelectRaw(sb);
        } else {
            this.type = StatementBuilder.StatementType.SELECT;
            this.appendColumns(sb);
        }
        sb.append("FROM ");
        this.databaseType.appendEscapedEntityName(sb, this.tableName);
        sb.append(' ');
        if (this.joinList != null) {
            this.appendJoinSql(sb);
        }
    }

    @Override
    protected FieldType[] getResultFieldTypes() {
        return this.resultFieldTypes;
    }

    @Override
    protected boolean appendWhereStatement(StringBuilder sb, List<ArgumentHolder> argList, StatementBuilder.WhereOperation operation) throws SQLException {
        boolean first;
        boolean bl = first = operation == StatementBuilder.WhereOperation.FIRST;
        if (this.where != null) {
            first = super.appendWhereStatement(sb, argList, operation);
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                operation = first ? StatementBuilder.WhereOperation.FIRST : joinInfo.operation;
                first = joinInfo.queryBuilder.appendWhereStatement(sb, argList, operation);
            }
        }
        return first;
    }

    @Override
    protected void appendStatementEnd(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        this.appendGroupBys(sb);
        this.appendHaving(sb);
        this.appendOrderBys(sb, argList);
        if (!this.databaseType.isLimitAfterSelect()) {
            this.appendLimit(sb);
        }
        this.appendOffset(sb);
        this.setAddTableName(false);
    }

    @Override
    protected boolean shouldPrependTableNameToColumns() {
        return this.joinList != null;
    }

    private void setAddTableName(boolean addTableName) {
        this.addTableName = addTableName;
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                super.setAddTableName(addTableName);
            }
        }
    }

    private void addJoinInfo(String type, QueryBuilder<?, ?> joinedQueryBuilder, StatementBuilder.WhereOperation operation) throws SQLException {
        JoinInfo joinInfo = new JoinInfo(type, joinedQueryBuilder, operation);
        this.matchJoinedFields(joinInfo, joinedQueryBuilder);
        if (this.joinList == null) {
            this.joinList = new ArrayList<JoinInfo>();
        }
        this.joinList.add(joinInfo);
    }

    private void matchJoinedFields(JoinInfo joinInfo, QueryBuilder<?, ?> joinedQueryBuilder) throws SQLException {
        for (FieldType fieldType : this.tableInfo.getFieldTypes()) {
            FieldType foreignIdField = fieldType.getForeignIdField();
            if (!fieldType.isForeign() || !foreignIdField.equals(joinedQueryBuilder.tableInfo.getIdField())) continue;
            joinInfo.localField = fieldType;
            joinInfo.remoteField = foreignIdField;
            return;
        }
        for (FieldType fieldType : joinedQueryBuilder.tableInfo.getFieldTypes()) {
            if (!fieldType.isForeign() || !fieldType.getForeignIdField().equals(this.idField)) continue;
            joinInfo.localField = this.idField;
            joinInfo.remoteField = fieldType;
            return;
        }
        throw new SQLException("Could not find a foreign " + this.tableInfo.getDataClass() + " field in " + joinedQueryBuilder.tableInfo.getDataClass() + " or vice versa");
    }

    private void addSelectColumnToList(String columnName) {
        this.verifyColumnName(columnName);
        this.selectColumnList.add(columnName);
    }

    private void appendJoinSql(StringBuilder sb) {
        for (JoinInfo joinInfo : this.joinList) {
            sb.append(joinInfo.type).append(" JOIN ");
            this.databaseType.appendEscapedEntityName(sb, joinInfo.queryBuilder.tableName);
            sb.append(" ON ");
            this.databaseType.appendEscapedEntityName(sb, this.tableName);
            sb.append('.');
            this.databaseType.appendEscapedEntityName(sb, joinInfo.localField.getColumnName());
            sb.append(" = ");
            this.databaseType.appendEscapedEntityName(sb, joinInfo.queryBuilder.tableName);
            sb.append('.');
            this.databaseType.appendEscapedEntityName(sb, joinInfo.remoteField.getColumnName());
            sb.append(' ');
            if (joinInfo.queryBuilder.joinList == null) continue;
            super.appendJoinSql(sb);
        }
    }

    private void appendSelectRaw(StringBuilder sb) {
        boolean first = true;
        for (String column : this.selectRawList) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
        }
        sb.append(' ');
    }

    private void appendColumns(StringBuilder sb) {
        if (this.selectColumnList == null) {
            if (this.addTableName) {
                this.databaseType.appendEscapedEntityName(sb, this.tableName);
                sb.append('.');
            }
            sb.append("* ");
            this.resultFieldTypes = this.tableInfo.getFieldTypes();
            return;
        }
        boolean first = true;
        boolean hasId = this.isInnerQuery;
        ArrayList<FieldType> fieldTypeList = new ArrayList<FieldType>(this.selectColumnList.size() + 1);
        for (String columnName : this.selectColumnList) {
            FieldType fieldType = this.tableInfo.getFieldTypeByColumnName(columnName);
            if (fieldType.isForeignCollection()) {
                fieldTypeList.add(fieldType);
                continue;
            }
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, fieldType, fieldTypeList);
            if (fieldType != this.idField) continue;
            hasId = true;
        }
        if (!hasId && this.selectIdColumn) {
            if (!first) {
                sb.append(',');
            }
            this.appendFieldColumnName(sb, this.idField, fieldTypeList);
        }
        sb.append(' ');
        this.resultFieldTypes = fieldTypeList.toArray(new FieldType[fieldTypeList.size()]);
    }

    private void appendFieldColumnName(StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        this.appendColumnName(sb, fieldType.getColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
    }

    private void appendLimit(StringBuilder sb) {
        if (this.limit != null && this.databaseType.isLimitSqlSupported()) {
            this.databaseType.appendLimitValue(sb, this.limit, this.offset);
        }
    }

    private void appendOffset(StringBuilder sb) throws SQLException {
        if (this.offset == null) {
            return;
        }
        if (this.databaseType.isOffsetLimitArgument()) {
            if (this.limit == null) {
                throw new SQLException("If the offset is specified, limit must also be specified with this database");
            }
        } else {
            this.databaseType.appendOffsetValue(sb, this.offset);
        }
    }

    private void appendGroupBys(StringBuilder sb) {
        boolean first = true;
        if (this.hasGroupStuff()) {
            this.appendGroupBys(sb, first);
            first = false;
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                if (joinInfo.queryBuilder == null || !super.hasGroupStuff()) continue;
                super.appendGroupBys(sb, first);
            }
        }
    }

    private boolean hasGroupStuff() {
        return this.groupByList != null && !this.groupByList.isEmpty() || this.groupByRaw != null;
    }

    private void appendGroupBys(StringBuilder sb, boolean first) {
        if (first) {
            sb.append("GROUP BY ");
        }
        if (this.groupByRaw != null) {
            if (!first) {
                sb.append(',');
            }
            sb.append(this.groupByRaw);
        } else {
            for (String columnName : this.groupByList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                this.appendColumnName(sb, columnName);
            }
        }
        sb.append(' ');
    }

    private void appendOrderBys(StringBuilder sb, List<ArgumentHolder> argList) {
        boolean first = true;
        if (this.hasOrderStuff()) {
            this.appendOrderBys(sb, first, argList);
            first = false;
        }
        if (this.joinList != null) {
            for (JoinInfo joinInfo : this.joinList) {
                if (joinInfo.queryBuilder == null || !super.hasOrderStuff()) continue;
                super.appendOrderBys(sb, first, argList);
            }
        }
    }

    private boolean hasOrderStuff() {
        return this.orderByList != null && !this.orderByList.isEmpty() || this.orderByRaw != null;
    }

    private void appendOrderBys(StringBuilder sb, boolean first, List<ArgumentHolder> argList) {
        if (first) {
            sb.append("ORDER BY ");
        }
        if (this.orderByRaw != null) {
            if (!first) {
                sb.append(',');
            }
            sb.append(this.orderByRaw);
            if (this.orderByArgs != null) {
                for (ArgumentHolder arg : this.orderByArgs) {
                    argList.add(arg);
                }
            }
            first = false;
        }
        if (this.orderByList != null) {
            for (OrderBy orderBy : this.orderByList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                this.appendColumnName(sb, orderBy.getColumnName());
                if (orderBy.isAscending()) continue;
                sb.append(" DESC");
            }
        }
        sb.append(' ');
    }

    private void appendColumnName(StringBuilder sb, String columnName) {
        if (this.addTableName) {
            this.databaseType.appendEscapedEntityName(sb, this.tableName);
            sb.append('.');
        }
        this.databaseType.appendEscapedEntityName(sb, columnName);
    }

    private void appendHaving(StringBuilder sb) {
        if (this.having != null) {
            sb.append("HAVING ").append(this.having).append(' ');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InternalQueryBuilderWrapper {
        private final QueryBuilder<?, ?> queryBuilder;

        InternalQueryBuilderWrapper(QueryBuilder<?, ?> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        public void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
            this.queryBuilder.appendStatementString(sb, argList);
        }

        public FieldType[] getResultFieldTypes() {
            return this.queryBuilder.getResultFieldTypes();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinInfo {
        final String type;
        final QueryBuilder<?, ?> queryBuilder;
        FieldType localField;
        FieldType remoteField;
        StatementBuilder.WhereOperation operation;

        public JoinInfo(String type, QueryBuilder<?, ?> queryBuilder2, StatementBuilder.WhereOperation operation) {
            this.type = type;
            this.queryBuilder = queryBuilder2;
            this.operation = operation;
        }
    }
}

