package com.rv.points.presenter;

import android.app.Activity;
import android.content.Context;

import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.points.Actions;
import com.rv.points.view.RegulationDialog;

import java.lang.reflect.Method;

public class PointPresenter extends CommonPresenter {

    private Class<?> userClass;
    private Actions actions;

    public void go(String methodName) {
        try {
            if (userClass == null || actions == null) {
                userClass = Actions.class;
                actions = (Actions) userClass.newInstance();
            }
            Method method = userClass.getMethod(methodName, Context.class);
            method.invoke(actions, getPresenterContext());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*******
     * 显示签到规则
     * @param activity
     */
    public void showRegulationDialog(Activity activity, String content) {
        new RegulationDialog.Builder(activity).setContent(content).create().show();
    }

}
