package com.rv.tourism.adapter;

import android.support.v4.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.tourism.R;
import com.rv.tourism.bean.BeanPopularBrigade;
import com.rv.tourism.bean.BeanTourDetailData;

/**
 * 选择出发时间
 */
public class TravelBookingDeparturetimeAdapter extends BaseQuickAdapter<BeanTourDetailData.DataBeanX.TourDepartTimeVo, BaseViewHolder> {
    private int selectPosition;

    public TravelBookingDeparturetimeAdapter() {
        super(R.layout.rv_item_travel_booking_departure_time);
    }

    @Override
    protected void convert(BaseViewHolder helper, BeanTourDetailData.DataBeanX.TourDepartTimeVo item) {
        String time = item.getStartTime() + getWeek(item.getStartWeek()) + "~" + item.getEndTime() + getWeek(item.getEndWeek());


        helper.setText(R.id.tv_time, time);
        if ("0".equals(item.getOverdue())) {
            if (selectPosition == mData.indexOf(item)) {
                helper.getView(R.id.iv_time_select).setSelected(true);
            } else {
                helper.getView(R.id.iv_time_select).setSelected(false);
            }
            helper.setTextColor(R.id.tv_time, ContextCompat.getColor(mContext, R.color.colorMain));
        } else {
            helper.setTextColor(R.id.tv_time, ContextCompat.getColor(mContext, R.color.textGray));
        }
    }

    public void setSelectPosition(int position) {
        this.selectPosition = position;
        notifyDataSetChanged();
    }


    public String getWeek(int no) {
        String week = "";
        switch (no) {
            case 0:
                week = "周日";
                break;
            case 1:
                week = "周一";
                break;
            case 2:
                week = "周二";
                break;
            case 3:
                week = "周三";
                break;
            case 4:
                week = "周四";
                break;
            case 5:
                week = "周五";
                break;
            case 6:
                week = "周六";
                break;
        }
        return week;
    }

}
