package com.rv.tourism.adapter;

import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.tourism.R;
import com.rv.tourism.bean.BeanPopularBrigade;
import com.rv.tourism.bean.BeanTourDetailData;

/**
 * 选择出发城市
 */
public class TravelBookingDepartureAdapter extends BaseQuickAdapter<BeanTourDetailData.DataBeanX.TourDepartVo, BaseViewHolder> {
    private int selectPosition;

    public TravelBookingDepartureAdapter() {
        super(R.layout.rv_item_travel_booking_departure);
    }

    @Override
    protected void convert(BaseViewHolder helper, BeanTourDetailData.DataBeanX.TourDepartVo item) {
        helper.setText(R.id.tv_company, item.getName());
        helper.setText(R.id.tv_address, item.getAddress());
        if (selectPosition == mData.indexOf(item)) {
            helper.getView(R.id.iv_company_select).setSelected(true);
        } else {
            helper.getView(R.id.iv_company_select).setSelected(false);
        }
    }

    public void setSelectPosition(int position) {
        this.selectPosition = position;
        notifyDataSetChanged();
    }
}
