package com.xxfc.rv.fragment;

import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.util.glide.GlideOptions;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.share.utils.TransformationUtils;
import com.xxfc.rv.R;

public class GuideFirstFragment extends BaseFragment<CommonPresenter> {

    public GuideFirstFragment() {

    }

    private ImageView imageView;
    private TextView textView1;
    private TextView textView2;

    @Override
    public int getViewLayout() {
        return R.layout.fragment_guide;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        imageView = getView().findViewById(R.id.image);
        textView1 = getView().findViewById(R.id.textview1);
        textView2 = getView().findViewById(R.id.textview2);
        textView1.setText("滴房车 全面上线");
        textView2.setText("开启你的房车新生活");
        GlideOptions options = GlideOptions.placeholderOf(R.drawable.icon_guide1);
        Glide.with(getActivity())
                .asBitmap()
                .load(R.drawable.icon_guide1)
                .apply(options)
                .into(new TransformationUtils(imageView));
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }
}
