package com.xxrv.wallet.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.widget.EditText;

import com.frame.base.bus.RxBus;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.api.WalletApi;
import com.xxrv.wallet.event.SetPasswordSuccessEvent;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

public class SetPayPwdActivity2 extends BaseStatusActivity<CommonPresenter> {

    @BindView(R2.id.edt_pwd1)
    EditText edtPwd1;
    @BindView(R2.id.edt_pwd2)
    EditText edtPwd2;
    @BindView(R2.id.edt_pwd3)
    EditText edtPwd3;
    @BindView(R2.id.edt_pwd4)
    EditText edtPwd4;
    @BindView(R2.id.edt_pwd5)
    EditText edtPwd5;
    @BindView(R2.id.edt_pwd6)
    EditText edtPwd6;

    private String phone;
    private String mobilecode;

    public static Intent getIntent(Context context, String phone, String mobilecode) {
        return new Intent(context, SetPayPwdActivity2.class)
                .putExtra("phone", phone)
                .putExtra("mobilecode", mobilecode);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType){
            case 0:
                showToast("密码设置成功！");
                RxBus.post(new SetPasswordSuccessEvent());
                finish();
                break;
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_set_pay_pwd2;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("设置支付密码");
        phone = intent.getStringExtra("phone");
        mobilecode = intent.getStringExtra("mobilecode");

        edtPwd1.addTextChangedListener(watcher);
        edtPwd2.addTextChangedListener(watcher);
        edtPwd3.addTextChangedListener(watcher);
        edtPwd4.addTextChangedListener(watcher);
        edtPwd5.addTextChangedListener(watcher);
        edtPwd6.addTextChangedListener(watcher);
    }

    private TextWatcher watcher = new TextWatcher() {
        @Override
        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            Log.e("xxxxx", charSequence.toString());
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            Log.e("xxxxx", charSequence.toString());
        }

        @Override
        public void afterTextChanged(Editable editable) {
            if (editable.toString().length() == 1) {
                if (edtPwd1.isFocused()) {
                    edtPwd1.clearFocus();
                    edtPwd2.requestFocus();
                } else if (edtPwd2.isFocused()) {
                    edtPwd2.clearFocus();
                    edtPwd3.requestFocus();
                } else if (edtPwd3.isFocused()) {
                    edtPwd3.clearFocus();
                    edtPwd4.requestFocus();
                } else if (edtPwd4.isFocused()) {
                    edtPwd4.clearFocus();
                    edtPwd5.requestFocus();
                } else if (edtPwd5.isFocused()) {
                    edtPwd5.clearFocus();
                    edtPwd6.requestFocus();
                } else if (edtPwd6.isFocused()) {
                    edtPwd6.requestFocus();
                }
            }
        }
    };

    @OnClick(R2.id.btn_item_confirm)
    public void onViewClicked() {
        String password = getEdittext(edtPwd1) + getEdittext(edtPwd2) + getEdittext(edtPwd3) + getEdittext(edtPwd4) + getEdittext(edtPwd5) + getEdittext(edtPwd6);
        if (TextUtils.isEmpty(password)){
            showToast("密码不能为空！");
            return;
        }

        if (password.length() != 6){
            showToast("请输入6位密码");
            return;
        }

        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());

        Map<String, Object> map = new LinkedHashMap<>();
        map.put("phone", phone);
        map.put("mobilecode", mobilecode);
        map.put("password", password);
        map.put("type", 1);
        mPresenter.postData(RvFrameConfig.HOST,0, WalletApi.HTTP_URL_WALLET_SETPWD, BaseBean.class, map,headMap, true);
    }


    private String getEdittext(EditText editText) {
        return editText.getText().toString().trim();
    }

}
