package com.rv.share.presenter;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.support.v7.widget.CardView;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.ShareUtils;
import com.rv.component.utils.StorageUtils;
import com.rv.share.view.ShareChoiceDialog;
import com.tencent.smtt.sdk.WebView;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.media.UMImage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class BillPresenter extends CommonPresenter {

    private ShareChoiceDialog dialog = null;
    private ShareAction shareAction = null;
    private CardView view = null;
    private Bitmap bitmap = null;
    private UMImage image = null;
    private WebView webView;

    public void showShareDialog(CardView llBillContent, WebView webView) {
        this.webView = webView;
        this.view = llBillContent;
        if (dialog == null) {
            dialog = new ShareChoiceDialog.Builder(getPresenterContext())
                    .setShareListener(myListener)
                    .setWxVisiable(true)
                    .setWxCVisiable(true)
                    .setQQVisiable(true)
                    .create();
        }
        dialog.show();
    }

    /*****
     * 保存海报
     * @param view
     */
    public void saveBill(View view) {
        if (view != null) {
            Bitmap bitmap = ShareUtils.viewConversionBitmap(view);
            File file = null;
            if (bitmap != null) {
                file = ShareUtils.saveBitmapFile(getPresenterContext(), bitmap);
            }
            if (file != null) {
                Toast.makeText(getPresenterContext(), "海报保存在" + file.getAbsolutePath(), Toast.LENGTH_LONG).show();
            }
        }
    }

    /******
     * 分享地址
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, String var2) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(var2);//分享内容
        shareAction.share();
    }

    /******
     * 分享文件
     * @param var1
     * @param var2
     */
    private void share(SHARE_MEDIA var1, UMImage var2, String content) {
        if (shareAction == null) {
            shareAction = new ShareAction((Activity) getPresenterContext()).setCallback(shareListener);
        }
        shareAction.setPlatform(var1)//传入平台
                .withText(content)
                .withMedia(var2);//分享内容
        shareAction.share();
    }

    /**
     * view转bitmap
     */
    public Bitmap viewConversionBitmap(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        int startX = (int) v.getX();
        int startY = (int) v.getY();
        Bitmap bmp = Bitmap.createBitmap(w, h, Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmp);
        c.drawColor(Color.WHITE);
        v.layout(startX, startY, w + startX, h + startY);
        v.draw(c);
        return bmp;
    }

    private File saveBitmapFile(Bitmap bitmap) {

        File parent = new File(StorageUtils.getPhotoSavePath(getPresenterContext()));
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File file = new File(parent, System.currentTimeMillis() + ".jpg");//将要保存图片的路径
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, bos);
            bos.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        StorageUtils.notifyImageChange(getPresenterContext(), file.getPath());
        return file;
    }

    private UMShareListener shareListener = new UMShareListener() {
        @Override
        public void onStart(SHARE_MEDIA share_media) {
            if (webView != null) {
                webView.loadUrl("javascript:shareSuccess()");
            }
        }

        @Override
        public void onResult(SHARE_MEDIA share_media) {
            if (webView != null) {
                webView.loadUrl("javascript:shareSuccess()");
            }
        }

        @Override
        public void onError(SHARE_MEDIA share_media, Throwable throwable) {
            Log.e("xxxxxxxxxx", "shareonError:" + throwable.getMessage());
        }

        @Override
        public void onCancel(SHARE_MEDIA share_media) {
            Log.e("xxxxxxxxxx", "shareonCancel");
        }
    };

    private ShareChoiceDialog.ShareListener myListener = new ShareChoiceDialog.ShareListener() {

        private void shareDeal() {
            if (view != null && bitmap == null) {
                bitmap = viewConversionBitmap(view);
            }
            File file = null;
            if (bitmap != null) {
                file = saveBitmapFile(bitmap);
            }
            if (file != null) {
                image = new UMImage(getPresenterContext(), file);//bitmap文件
                UMImage thumb = new UMImage(getPresenterContext(), file);
                image.setThumb(thumb);
                image.compressStyle = UMImage.CompressStyle.SCALE;//大小压缩，默认为大小压缩，适合普通很大的图
                image.compressStyle = UMImage.CompressStyle.QUALITY;//质量压缩，适合长图的分享
                image.compressFormat = Bitmap.CompressFormat.PNG;
            }
        }

        @Override
        public void copyShare() {

        }

        @Override
        public void wxShare() {
            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN, image, "");
            }
        }

        @Override
        public void wxCShare() {

            if (image == null) {
                shareDeal();
            }
            if (image != null) {
                share(SHARE_MEDIA.WEIXIN_CIRCLE, image, "");
            }
        }

        @Override
        public void qqShare() {

        }

        @Override
        public void billShare() {

        }

        @Override
        public void close() {
        }
    };


    @Override
    public void detachView() {
        super.detachView();
        if (bitmap != null) {
            bitmap.recycle();
        }
    }


}
