package com.rv.points;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.base.utils.ui.image.round.RoundImageView;
import com.bumptech.glide.Glide;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.bus.PaymentFailedEvent;
import com.frame.base.bus.PaymentSuccessfulEvent;
import com.frame.base.bus.RxBus;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.bean.UserInfoBean;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.RvCache;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.DisplayUtil;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.ui.main.home.order.OrderListActivity;
import com.rv.points.adapter.PointAdapter;
import com.rv.points.bean.PointBean;
import com.rv.points.bean.RulerBean;
import com.rv.points.bean.UserPointInfoBean;
import com.rv.points.presenter.PointPresenter;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;

public class PointsActivity extends BaseStatusActivity<PointPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.rimg_avatar)
    RoundImageView imageView;
    @BindView(R2.id.tv_name)
    TextView tvName;
    @BindView(R2.id.tv_point)
    TextView tvPoint;
    @BindView(R2.id.img_back)
    ImageView imgBack;
    private PointAdapter adapter;
    private UserInfoBean userInfo;
    private Disposable disposable = null;

    private List<PointBean.RvPointItem> points = new ArrayList<>();

    @Override
    protected int setLayout() {
        return R.layout.activity_points;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        imgBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });
        userInfo = (UserInfoBean) RvCache.getInstance(getApplicationContext()).get(CacheEnum.USER);
        if (userInfo != null && userInfo.getData() != null) {
            if (!TextUtils.isEmpty(userInfo.getData().getHeadimgurl())) {
                GlideManager.getInstance(getApplicationContext()).loadImage(userInfo.getData().getHeadimgurl(), imageView);
            }

            if (!TextUtils.isEmpty(userInfo.getData().getNickname())) {
                tvName.setText(userInfo.getData().getNickname());
            }
        }
        recyclerView.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
        adapter = new PointAdapter(this, points);
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(new PointAdapter.OnItemClickListener() {
            @Override
            public void openSignRuler(String code) {
                if (!TextUtils.isEmpty(code))
                    getSignRuler(code);
            }

            @Override
            public void onClick(PointBean.RvPointItem item) {
                if (!TextUtils.isEmpty(item.getCode()))
                    mPresenter.go(item.getCode().toLowerCase().trim());
            }
        });

        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == RecyclerView.SCROLL_STATE_IDLE) {
                    Glide.with(PointsActivity.this).resumeRequests();//恢复Glide加载图片
                } else {
                    Glide.with(PointsActivity.this).pauseRequests();//禁止Glide加载图片
                }
            }
        });
    }


    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getUserPointInfo();
        getPointList();
    }

    /********
     * 获取用户积分信息
     */
    private void getUserPointInfo() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URR_USER_POINT, UserPointInfoBean.class, header, true);
        }
    }

    /*********
     * 获取积分列表
     */
    private void getPointList() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 1, ApiConfig.HTTP_URL_POINT_LIST, PointBean.class, header, true);
        }
    }

    /*****
     * 获取签到规则
     */
    private void getSignRuler(String code) {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());
            mPresenter.getDataHead(RvFrameConfig.HOST, 2, String.format(ApiConfig.HTTP_URL_POINT_SIGN_RULER, code), RulerBean.class, header, true);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        if (requestType == 1) {
            PointBean pointBean = (PointBean) result;
            if (pointBean.getData() != null && pointBean.getData().getData() != null) {
                points.clear();
                points.addAll(pointBean.getData().getData());
                adapter.notifyDataSetChanged();
            }
        }

        if (requestType == 0) {
            if (result != null && result instanceof UserPointInfoBean) {
                UserPointInfoBean pointInfoBean = (UserPointInfoBean) result;
                if (pointInfoBean.getData() != null) {
                    String text = pointInfoBean.getData().getRestPoint() + "\n积分";
                    int position = text.indexOf("积分");
                    SpannableString sStr = new SpannableString(text);
                    sStr.setSpan(new AbsoluteSizeSpan(DisplayUtil.sp2px(this, 12)), position, position + 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    sStr.setSpan(new ForegroundColorSpan(Color.parseColor("#F8F3C9")), position, position + 2, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    tvPoint.setText(sStr);
                }
            }
        }

        if (requestType == 2) {
            if (result != null && result instanceof RulerBean) {
                RulerBean bean = (RulerBean) result;
                if (bean.getData() != null) {
                    mPresenter.showRegulationDialog(PointsActivity.this, bean.getData().getDetail());
                }
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        getUserPointInfo();
        getPointList();
    }

//    @SuppressLint("CheckResult")
//    private void initRxBus() {
//        disposable = RxBus.tObservable(BindWechatEvent.class)
//                .observeOn(Schedulers.io())
//                .subscribe(new Consumer<BindWechatEvent>() {
//                    @Override
//                    public void accept(BindWechatEvent event) throws Exception {
//
//                    }
//                });
//    }
}
