package com.xxrv.coupon;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.fastjson.JSON;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.coupon.adapter.CarCouponAdapter;
import com.xxrv.coupon.bean.CarCouponBean;
import com.xxrv.coupon.bean.CouponBean;
import com.xxrv.coupon.presenter.CouponAllPresenter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 租车优惠券
 */
@Route(path = Constance.ACTIVITY_URL_CARCOUPON)
public class CarCouponActivity extends BaseStatusActivity<CouponAllPresenter> {
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.iv_select)
    ImageView ivSelect;

    private CarCouponAdapter mAdapter;
    List<CarCouponBean.DataBean.CarCouponTypeDataBean> couponBeans;

    @Autowired()
    String coupon;

    @Autowired()
    String selectCoupon;

    private List<CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean> couponList;
    private List<CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean> selectcarCouponDataBeans;

    private boolean select;  //保留上一次选中的

    @Override
    protected int setLayout() {
        return R.layout.activity_car_coupon;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("优惠券");

        couponList = new ArrayList<>();

        mAdapter = new CarCouponAdapter(new ArrayList<MultiItemEntity>());
        rvContent.setLayoutManager(new LinearLayoutManager(mActivity, LinearLayoutManager.VERTICAL, false));
        rvContent.setAdapter(mAdapter);

        if (selectCoupon != null) {
            selectcarCouponDataBeans = JSON.parseArray(selectCoupon, CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean.class);
        }

        if (coupon != null) {
            couponBeans = JSON.parseArray(coupon, CarCouponBean.DataBean.CarCouponTypeDataBean.class);

            List<MultiItemEntity> multiList = new ArrayList<>();
            for (CarCouponBean.DataBean.CarCouponTypeDataBean bean : couponBeans) {
                multiList.add(bean);
                for (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean childrenBean : bean.getList()) {
                    if (selectcarCouponDataBeans != null) {
                        for (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean selectCoupon : selectcarCouponDataBeans) {
                            if (selectCoupon.getTickerNo().equals(childrenBean.getTickerNo())) {
                                childrenBean.setCheck(true);
                            }
                        }
                    }
                    multiList.add(childrenBean);
                }
            }
            mAdapter.addData(multiList);
        }

        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                MultiItemEntity bean = mAdapter.getItem(position);
                if (bean instanceof CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) {
                    ivSelect.setSelected(false);
                    CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean couponBean = (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) bean;
                    if ("1".equals(couponBean.getStatus())) {
                        select = couponBean.isCheck();
                        List<MultiItemEntity> data = mAdapter.getData();
                        if (data != null && data.size() > 0) {
                            for (int i = 0; i < data.size(); i++) {
                                MultiItemEntity bean2 = data.get(i);
                                if (bean2 instanceof CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) {
                                    CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean data2 = (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) bean2;
                                    if (data2.getType().equals(couponBean.getType())) {
                                        data2.setCheck(false);
                                    }
                                }
                            }
                            if (select) {
                                couponBean.setCheck(false);
                            } else {
                                couponBean.setCheck(true);
                            }
                        }
                        mAdapter.notifyDataSetChanged();
                    }
                }
            }
        });
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.btn_item_ok, R2.id.ll_item_coupon_air})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.btn_item_ok) {
            couponList.clear();
            List<MultiItemEntity> data = mAdapter.getData();
            if (data != null && data.size() > 0) {
                for (int i = 0; i < data.size(); i++) {
                    MultiItemEntity multiItemEntity = data.get(i);
                    if (multiItemEntity instanceof CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) {
                        CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean data2 = (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) multiItemEntity;
                        if (data2.isCheck()) {
                            couponList.add(data2);
                        }
                    }
                }
            }
            getIntent().putExtra("resultCouponList", JSON.toJSONString(data));
            getIntent().putExtra("selectCoupon", JSON.toJSONString(couponList));
            setResult(RESULT_OK, getIntent());
            finish();
        } else if (id == R.id.ll_item_coupon_air) {
            ivSelect.setSelected(true);
            List<MultiItemEntity> data = mAdapter.getData();
            if (data != null && data.size() > 0) {
                for (int i = 0; i < data.size(); i++) {
                    MultiItemEntity bean2 = data.get(i);
                    if (bean2 instanceof CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) {
                        CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean data2 = (CarCouponBean.DataBean.CarCouponTypeDataBean.CarCouponDataBean) bean2;
                        data2.setCheck(false);
                    }
                }
            }
            mAdapter.notifyDataSetChanged();
        }
    }
}
