package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.DisplayUtil;
import com.rv.component.utils.ZxingUtils;
import com.rv.home.R;
import com.rv.home.R2;
import com.ruiwenliu.wrapper.base.presenter.PickerPresenter;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 出示上车二维码
 */
public class GetOnTheCarQRCodeActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.iv_zxing)
    ImageView ivZxing;
    @BindView(R2.id.iv_back)
    ImageView ivBack;
    @BindView(R2.id.tv_center)
    TextView tvCenter;
    @BindView(R2.id.iv_customer_service)
    TextView ivCustomerService;
    @BindView(R2.id.iv_goods)
    ImageView ivGoods;
    @BindView(R2.id.tv_car_type)
    TextView tvCarType;
    @BindView(R2.id.tv_get_time)
    TextView tvGetTime;
    @BindView(R2.id.tv_out_address)
    TextView tvOutAddress;
    @BindView(R2.id.tv_get_address)
    TextView tvGetAddress;


    private OrderListBean.DataBeanX.DataBean dataBean;

    public static Intent getIntent(Context context, OrderListBean.DataBeanX.DataBean dataBean) {
        return new Intent(context, GetOnTheCarQRCodeActivity.class)
                .putExtra("dataBean", dataBean);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_get_on_the_car_qrcode;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);


        dataBean = (OrderListBean.DataBeanX.DataBean) intent.getSerializableExtra("dataBean");

        if (dataBean != null) {
            tvCarType.setText(dataBean.getName());
            OrderListBean.DataBeanX.DataBean.OrderTourDetail detail = dataBean.getOrderTourDetail();
            if (detail != null) {
                tvGetTime.setText(TimeManager.stampToDate(String.valueOf(detail.getStartTime())) + "-" + TimeManager.stampToDate(String.valueOf(detail.getEndTime())));
                tvGetAddress.setText(detail.getStartAddr());
                tvOutAddress.setText(detail.getEndAddr());
                GlideManager.getInstance(mActivity).loadRoundImage(dataBean.getPicture(), ivGoods, 8);
            }
        }

        if (!TextUtils.isEmpty(dataBean.getQrcodeStr())) {
            Bitmap bitmap = ZxingUtils.createQR(dataBean.getQrcodeStr(), DisplayUtil.dip2px(this, 200), DisplayUtil.dip2px(this, 200));
            ivZxing.setImageBitmap(bitmap);
        }
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.iv_back, R2.id.iv_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.iv_customer_service) {
            showToast("该功能还在开发中...");
        }
    }
}
