package com.rv.home.rv.module.ui.main.home.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.view.StarBar;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.component.utils.DisplayUtil;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.ui.main.home.bean.CarTypeListBean;
import com.rv.home.rv.module.ui.main.home.bean.ShopListBean;

/**
 * Created :Auser
 * Date: 2019/5/16.
 * Desc:租车列表适配器
 * https://blog.csdn.net/anita9999/article/details/82346552
 */

public class CarRentalListAdapter extends BaseQuickAdapter<CarTypeListBean.DataBeanX.DataBean, BaseGlideHolder> {
    public CarRentalListAdapter() {
        super(R.layout.rv_item_car_rental_list);
    }

    @Override
    protected void convert(BaseGlideHolder helper, CarTypeListBean.DataBeanX.DataBean item) {
        if (item.getVehicleModel() != null) {
            helper.setText(R.id.tv_name, item.getVehicleModel().getName());
            helper.setText(R.id.tv_context, item.getVehicleModel().getKeyword());
            helper.setText(R.id.tv_point, String.valueOf(item.getVehicleModel().getPoint()));

            String icon ="";
            if (!TextUtils.isEmpty(item.getVehicleModel().getCoverPic())){
                icon = item.getVehicleModel().getCoverPic();
            }else {
                icon = item.getVehicleModel().getIcon();
            }

            helper.loadRoundImage(mContext, icon, (ImageView) helper.getView(R.id.iv_goods), 10, DisplayUtil.dip2px(mContext,  helper.getView(R.id.iv_goods).getWidth()), DisplayUtil.dip2px(mContext, helper.getView(R.id.iv_goods).getHeight()));
//        helper.setText(R.id.tv_name,item);
            helper.setText(R.id.tv_price, String.format("¥%1$s%2$s", item.getVehicleModel().getPrice(), mContext.getString(R.string.rv_day)));
            float score = (float) item.getVehicleModel().getScore() / 10;
            StarBar starBar = helper.getView(R.id.starbar1);
            starBar.setStarMark(score);
            starBar.setVisibility(View.GONE);
            helper.setText(R.id.tv_point, score + "");
            if ("0".equals(item.getHasVehicle())) {
                helper.setGone(R.id.iv_sold_out, true);
                helper.setGone(R.id.tv_layout_gray, true);

            } else if ("1".equals(item.getHasVehicle())) {
                helper.setGone(R.id.iv_sold_out, false);
                helper.setGone(R.id.tv_layout_gray, false);
            }

        }

        helper.setText(R.id.tv_address, item.getCompany().getName());

        double instance = item.getDistance() / 1000;

        helper.setText(R.id.tv_km, String.format("%s%d%s", mContext.getString(R.string.rv_km_you), new Double(instance).intValue(), mContext.getString(R.string.rv_km)));
    }
}
