package com.rv.home.rv.module.basic;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.webview.SafeWebView;
import com.rv.home.R;
import com.ruiwenliu.wrapper.base.presenter.PickerPresenter;
import com.rv.home.R2;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

import butterknife.BindView;

@Route(path = Constance.ACTIVITY_URL_WEBVIEW)
public class WebActivity extends BaseStatusActivity<PickerPresenter> {
    @BindView(R2.id.pb_progress)
    ProgressBar pbProgress;
    @BindView(R2.id.webView)
    SafeWebView mWebView;
    @BindView(R2.id.lay_web)
    LinearLayout mRoot;

    @Autowired()
    String title;
    @Autowired()
    String url;
    @Autowired()
    int type;

    public static Intent getIntent(Context context, String title, String url) {
        return new Intent(context, WebActivity.class)
                .putExtra("title", title)
                .putExtra("url", url);
    }


    @Override
    protected int setLayout() {
        return R.layout.rv_activity_web;
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(intent.getStringExtra("title"));
        String url = intent.getStringExtra("url");
        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return super.shouldOverrideUrlLoading(view, request);
            }
        });
        if (0 == type) {
            mWebView.loadUrl(url);
        } else {
            String baseUrl = url + "?type=" + type;
            Log.i("webactivityactivyt", "initView: ----" +baseUrl);
            mWebView.loadUrl(baseUrl);
        }

        mWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if(newProgress==100){
                    pbProgress.setVisibility(View.GONE);//加载完网页进度条消失
                }
                else{
                    pbProgress.setVisibility(View.VISIBLE);//开始加载网页时显示进度条
                    pbProgress.setProgress(newProgress);//设置进度值
                }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }


    @Override
    public void onResume() {
        super.onResume();
        mWebView.onResume();
        mWebView.resumeTimers();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mWebView.onPause();
        mWebView.pauseTimers();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mRoot != null) {
            mRoot.removeView(mWebView);
        }
        if (mWebView != null) {
            mWebView.stopLoading();
            mWebView.clearMatches();
            mWebView.clearHistory();
            mWebView.clearSslPreferences();
            mWebView.clearCache(true);
            mWebView.loadUrl("about:blank");
            mWebView.removeAllViews();
            if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                mWebView.removeJavascriptInterface("AndroidNative");
            }
            mWebView.destroy();
        }
        mWebView = null;
    }


}
