package com.xxfc.discovery.fragment;

import android.graphics.Rect;
import android.os.Bundle;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Display;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.xxfc.discovery.R;
import com.xxfc.discovery.R2;
import com.xxfc.discovery.adapter.DiscoveryRecommendAdapter;
import com.xxfc.discovery.api.DiscoveryApi;
import com.xxfc.discovery.bean.DiscoveryRecommendBean;
import com.xxfc.discovery.presenter.DiscoveryPresenter;

import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

/**
 * 短视频
 */
public class ShortVideoFragment extends BaseFragment<DiscoveryPresenter>  implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener{

    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout mSimpleRefreshLayout;

    private DiscoveryRecommendAdapter mAdapter;
    private int countPage;
    private int mPage;


    public static ShortVideoFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        ShortVideoFragment fragment = new ShortVideoFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_short_video;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        mSimpleRefreshLayout.setHeaderView(new SimpleRefreshView(_mActivity));
        mSimpleRefreshLayout.setOnSimpleRefreshListener(this);
        Display display = _mActivity.getWindowManager().getDefaultDisplay();
        mAdapter = new DiscoveryRecommendAdapter(display);
        rvContent.setLayoutManager(new GridLayoutManager(_mActivity, 2));
        rvContent.addItemDecoration(new AbSpacesItemDecoration(15));// 分割线。
        rvContent.setAdapter(mAdapter);

    }

    @Override
    protected void loadData(Bundle savedInstanceState) {
        onFresh();
    }

    /**
     * 刷新
     */
    private void onFresh() {
        mPage = 1;
        geDataList(mPage);
    }

    /**
     * 请求数据
     *
     * @param page
     */
    private void geDataList(int page) {
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        map.put("type",4);
        mPresenter.postData(0, DiscoveryApi.DISCOVERY_UNAUTH_LIST, DiscoveryRecommendBean.class, map,  page == 1 ? false : false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        mSimpleRefreshLayout.onRefreshComplete();
        processData((DiscoveryRecommendBean) result);
    }

    private void processData(DiscoveryRecommendBean bean) {
        if (mPage == 1) {
            countPage = bean.getData().getTotalPage();
            mAdapter.setNewData(bean.getData().getList());
            if (bean.getData().getTotalCount() == 0) {
//                mAdapter.setEmptyView(getEmptyView(rvContent, -1, "暂无拍拍数据"));
//                mAdapter.notifyDataSetChanged();
            }
        } else {
            mAdapter.addData(bean.getData().getList());
            mAdapter.loadMoreComplete();
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (mPage >= countPage) {
            mAdapter.loadMoreEnd();
        } else {
            mPage++;
            geDataList(mPage);
        }
    }

    @Override
    public void onRefresh() {
        onFresh();
    }



    public class AbSpacesItemDecoration extends RecyclerView.ItemDecoration {

        private int space;

        public AbSpacesItemDecoration(int space) {
            this.space = space;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = space;
            outRect.right = space;
            outRect.bottom = space;
            outRect.top = space;
        }
    }
}
