package com.base.utils.tools.exception;

import android.content.Context;

/**
 * 异常捕获的工具
 */

public class ExceptionCatchUtil implements Thread.UncaughtExceptionHandler {
    private static ExceptionCatchUtil instance;
    private Context context;
    private OnExceptionHandleListener listener;

    private ExceptionCatchUtil(Context context,OnExceptionHandleListener listener) {
        this.context = context;
        this.listener = listener;
    }

    public static ExceptionCatchUtil getInstance(Context context,OnExceptionHandleListener listener) {
        if (instance == null)
            return new ExceptionCatchUtil(context,listener);
        return instance;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        //相关UI处理
        if (listener!=null){
            listener.onExceptionHandle(throwable);
        }
    }

    public interface OnExceptionHandleListener{
        void onExceptionHandle(Throwable throwable);
    }
}
