package com.xxfc.rv;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.TextUtils;

import com.rv.component.utils.Cookie;
import com.rv.component.utils.LogUtil;
import com.sh.sdk.shareinstall.ShareInstall;
import com.sh.sdk.shareinstall.listener.AppGetInfoListener;

import org.json.JSONException;
import org.json.JSONObject;

import java.net.URLDecoder;

/********
 * shareInstall 唤醒界面
 */
public class WakeUpActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.rv_act_weclome);
        ShareInstall.getInstance().getInfo(getIntent(), listener);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        // 此处要调用，否则app在后台运行时，会无法截获
        ShareInstall.getInstance().getInfo(intent, listener);
    }

    private AppGetInfoListener listener = info -> {
        LogUtil.d("ShareInstall", "info = " + info);
        Intent intent = new Intent(getApplicationContext(), MainActivity.class);
        if (info.contains("code"))
            try {
                JSONObject object = new JSONObject(info);
                String inviteCode = object.optString("code");
                if (!TextUtils.isEmpty(inviteCode)) {
                    Cookie.save(getApplicationContext(), "code", inviteCode);
                }
                String url = object.optString("url");
                LogUtil.d("唤醒传过来的url=" + url);
                String title = URLDecoder.decode(object.optString("title"), "UTF-8");
                LogUtil.d("唤醒传过来的tile=" + title);
                if (!TextUtils.isEmpty(url) && !TextUtils.isEmpty(title)) {
                    intent.putExtra("to", "webView");
                    intent.putExtra("url", url);
                    intent.putExtra("title", title);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        startActivity(intent);
        finish();
    };
}
