package com.xxfc.rv;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.alibaba.android.arouter.launcher.ARouter;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseWrapperFragment;
import com.ruiwenliu.wrapper.bean.ActBean;
import com.ruiwenliu.wrapper.statusbar.StatusBarUtil;
import com.ruiwenliu.wrapper.util.listener.SwitchFragment;
import com.ruiwenliu.wrapper.weight.CustomScrollViewPager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.camp.CampFragment;
import com.rv.component.utils.Cookie;
import com.rv.home.rv.module.ApiConfig;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.HomeFragment;
import com.rv.home.rv.module.ui.main.home.bean.EffectiveTimeBean;
import com.rv.rvmine.MineFragment;
import com.rv.share.WebViewActivity;
import com.rv.share.view.PromotionDialog;
import com.rv.tourism.R2;
import com.rv.tourism.TourismFragment;
import com.rv.version.bean.VersionCheckBean;
import com.rv.version.util.DownloadAppUtils;
import com.rv.version.util.UpdateAppUtils;
import com.xxfc.discovery.DiscoveryFragment;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;


public class MainActivity extends BaseActivity<CommonPresenter> {

    //    @BindView(R2.id.pager_view_fragment)
    CustomScrollViewPager viewPager;
    @BindView(R2.id.iv_home)
    ImageView ivHome;
    @BindView(R2.id.tv_home)
    TextView tvHome;
    @BindView(R2.id.iv_travel)
    ImageView ivTravel;
    @BindView(R2.id.tv_travel)
    TextView tvTravel;
    @BindView(R2.id.iv_camp)
    ImageView ivCamp;
    @BindView(R2.id.tv_camp)
    TextView tvCamp;
    @BindView(R2.id.iv_found)
    ImageView ivFound;
    @BindView(R2.id.tv_found)
    TextView tvFound;
    @BindView(R2.id.iv_mine)
    ImageView ivMine;
    @BindView(R2.id.tv_mine)
    TextView tvMine;
    private TabAdapter mAdapter;
    private final int TYPE_HOME_PAGE = 0;//首页
    private final int TYPE_TRAVEL = 1;//旅行
    private final int TYPE_CAMP = 2;//营地
    private final int TYPE_FOUND = 3;//旅行
    private final int TYPE_MINE = 4;//我的
    private long exitTime = 0;


    private UpdateAppUtils updateAppUtils;
    private PromotionDialog promotionDialog;

    public static Intent getIntent(Context context) {
        return new Intent(context, MainActivity.class);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_main;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBarUtil.setRootViewFitsSystemWindows(mActivity, false);
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        updateAppUtils = UpdateAppUtils.from(MainActivity.this);
        viewPager = findViewById(R.id.pager_view_fragment);
        showTitle(false);
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        viewPager.setAdapter(mAdapter);
        viewPager.setOffscreenPageLimit(5);
        setCurrent(TYPE_HOME_PAGE);

        SwitchFragment.setFragmentSelected(postion -> setCurrent(postion));
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        wakeUp(intent);
        getEffectiveTime();
        getActivityPopup();
        checkVersion();
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                VersionCheckBean versionCheckBean = (VersionCheckBean) result;
                if (versionCheckBean != null && versionCheckBean.isRel() == false) {

                    if (versionCheckBean != null && !TextUtils.isEmpty(versionCheckBean.getData().getDownloadUrl())) {
                        updateAppUtils.serverVersionCode(versionCheckBean.getData().getWeigh())
                                .serverVersionName(versionCheckBean.getData().getVersionName())
                                .apkPath(versionCheckBean.getData().getDownloadUrl())
                                .updateInfo(versionCheckBean.getData().getContent())
                                .apkSize(versionCheckBean.getData().getPackagesize())
                                .isForce(versionCheckBean.getData().getIsCompel() == 0 ? false : true)
                                .update();
                    }
                }
                break;
            case 1:
                EffectiveTimeBean bean = (EffectiveTimeBean) result;
                if (bean != null && bean.isRel() && bean.getData() != null) {
                    Cookie.save(getApplicationContext(), "actRent", bean.getData().getActRent());
                    Cookie.save(getApplicationContext(), "actTour", bean.getData().getActTour());
                    Cookie.save(getApplicationContext(), "insurePrice", bean.getData().getInsurePrice());
                    Cookie.save(getApplicationContext(), "actMember", bean.getData().getActMember());
                }
                break;
            case 2:
                final ActBean actBean = (ActBean) result;
                if (actBean != null && actBean.isRel() && actBean.getData() != null && actBean.getData().size() > 0) {
                    final ActBean.Act act = actBean.getData().get(0);
                    mPresenter.saveOnclick("0", String.valueOf(act.getId()));
                    promotionDialog = new PromotionDialog.Builder(this, new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            promotionDialog.dismiss();
                            mPresenter.saveOnclick("1", String.valueOf(act.getId()));
                            postActivityPopup(act.getId());
                            startActivity(WebViewActivity.getIntent(getApplicationContext(), act.getUrl(), act.getName()));
                        }
                    }).setData(act).create();
                    promotionDialog.show();
                }
                break;
            default:
                break;
        }
    }

    private void getActivityPopup() {
        Map<String, Object> map = new HashMap<>();
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            map.put("Authorization", OkGoUtil.getToken());
        }
        mPresenter.getDataHead(RvFrameConfig.HOST, 2, ApiConfig.HTTP_URL_GET_ACT, ActBean.class, map, true);
    }

    private void postActivityPopup(int id) {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> map = new HashMap<>();
            map.put("Authorization", OkGoUtil.getToken());
            mPresenter.postData(1000, String.format(ApiConfig.HTTP_URL_POST_ACT, id), BaseBean.class, map, false);
        }
    }


    @OnClick({R2.id.rl_home, R2.id.rl_travel, R2.id.rl_camp, R2.id.rl_found, R2.id.rl_mine})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_home) {
            setCurrent(TYPE_HOME_PAGE);
        } else if (id == R.id.rl_travel) {
            setCurrent(TYPE_TRAVEL);
        } else if (id == R.id.rl_camp) {
            setCurrent(TYPE_CAMP);
        } else if (id == R.id.rl_found) {
            setCurrent(TYPE_FOUND);
        } else if (id == R.id.rl_mine) {
            setCurrent(TYPE_MINE);
        }
    }

    private List<BaseWrapperFragment> getListFragment() {
        List<BaseWrapperFragment> list = new ArrayList<>();
        list.add(HomeFragment.getInstance(TYPE_HOME_PAGE));
        list.add(TourismFragment.getInstance(TYPE_TRAVEL));
        list.add(CampFragment.getInstance(TYPE_CAMP));
        list.add(DiscoveryFragment.getInstance(TYPE_FOUND));
        list.add(MineFragment.getInstance(TYPE_MINE));
        return list;
    }

    /**
     * 设置切换
     *
     * @param index
     */
    public void setCurrent(int index) {
        setViewStyle(ivHome, tvHome, index == TYPE_HOME_PAGE);
        setViewStyle(ivTravel, tvTravel, index == TYPE_TRAVEL);
        setViewStyle(ivCamp, tvCamp, index == TYPE_CAMP);
        setViewStyle(ivFound, tvFound, index == TYPE_FOUND);
        setViewStyle(ivMine, tvMine, index == TYPE_MINE);
        viewPager.setCurrentItem(index, false);
    }

    /**
     * 设置view的样式
     */
    private void setViewStyle(ImageView imageView, TextView textView, boolean isTrue) {
        imageView.setSelected(isTrue);
        textView.setTextColor(ContextCompat.getColor(this, isTrue ? R.color.gray_FFB74B : R.color.textMain));
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (mAdapter != null) {
            mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);
        }

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1001:
                if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    updateAppUtils.download();
                } else {
                    Toast.makeText(getApplicationContext(), "授权失败,无法下载最新App", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
            if (event.getAction() == KeyEvent.ACTION_DOWN && event.getRepeatCount() == 0) {
                exitApp();
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent != null && "home".equals(intent.getStringExtra("to"))) {
            setCurrent(TYPE_HOME_PAGE);
        } else if (intent != null && "travel".equals(intent.getStringExtra("to"))) {
            setCurrent(TYPE_TRAVEL);
        } else if (intent != null && "discovery".equals(intent.getStringExtra("to"))) {
            setCurrent(TYPE_FOUND);
        } else if (intent != null && "mine_coupons".equals(intent.getStringExtra("to"))) {
            setCurrent(TYPE_MINE);
            ARouter.getInstance()
                    .build(Constance.ACTIVITY_URL_COUPONALL)
                    .navigation();
        } else if (intent != null && "mine_wallet".equals(intent.getStringExtra("to"))) {
            setCurrent(TYPE_MINE);
            ARouter.getInstance()
                    .build(Constance.ACTIVITY_URL_WALLET)
                    .navigation();
        } else {
            wakeUp(intent);
        }
    }

    /****
     * 检测版本
     */
    private void checkVersion() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        String versionName = updateAppUtils.getAppVersionName(this);
        if (!TextUtils.isEmpty(versionName)) {
            mPresenter.getData(0, String.format(ApiConfig.HTTP_URL_VERSION_CHECK, versionName), VersionCheckBean.class, headMap, false);

        }
    }

    private void getEffectiveTime() {
        mPresenter.getData(1, ApiConfig.HTTP_URL_EFFECTIVE_TIME, EffectiveTimeBean.class, false);
    }

    /**
     * 退出APP
     */
    private void exitApp() {
        if (System.currentTimeMillis() - exitTime > 2000) {
            showToast("再按一次，退出程序");
            exitTime = System.currentTimeMillis();
        } else {
            finish();
        }
    }

    /**
     * 判断是否登录
     *
     * @return
     */
    private boolean isLogin() {
        if (TextUtils.isEmpty(OkGoUtil.getToken())) {
            return false;
        }
        return true;
    }

    /******
     * 唤醒Apk，跳转到webView页面
     * @param intent
     */
    private void wakeUp(Intent intent) {

        if ("webView".equals(intent.getStringExtra("to"))) {
            if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
                Map<String, Object> header = new HashMap<>();
                header.put("Authorization", OkGoUtil.getToken());

                Map<String, Object> body = new HashMap<>();
                body.put("code", Cookie.getStringValue(getApplicationContext(), "code"));

                mPresenter.postData(RvFrameConfig.HOST, 10000, ApiConfig.HTTP_URL_RELATION_BIND, null, body, header, false);
            }
            ComponentName componentName = new ComponentName(this, "com.rv.share.WebViewActivity");
            Intent in = new Intent();
            in.setComponent(componentName);
            in.putExtra("url", intent.getStringExtra("url"));
            in.putExtra("title", intent.getStringExtra("title"));
            startActivity(in);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        DownloadAppUtils.unRegisterReceiver(getApplicationContext());
    }
}
