package com.rv.share;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.base.utils.ui.image.round.RoundImageView;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.share.presenter.BillPresenter;

import butterknife.BindView;
import butterknife.OnClick;

/********
 *
 * 海报界面
 * created by john
 */
public class BillActivity extends BaseStatusActivity<BillPresenter> {

    @BindView(R2.id.tv_back_title)
    TextView tvBackTitle;
    @BindView(R2.id.btn_share)
    Button btnShare;
    @BindView(R2.id.rimg_avatar)
    RoundImageView imageView;
    @BindView(R2.id.tv_name)
    TextView tvName;
    @BindView(R2.id.img_zxing)
    ImageView imgZxing;
    @BindView(R2.id.ll_long_click)
    LinearLayout llLongClick;
    @BindView(R2.id.ll_bill_content)
    LinearLayout llBillContent;

    @Override
    protected int setLayout() {
        return R.layout.activity_bill;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setVisibility(View.GONE);
        llLongClick.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View view) {
                mPresenter.showShareDialog(llBillContent);
                return false;
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.tv_back_title, R2.id.btn_share, R2.id.ll_long_click})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.tv_back_title) {
            finish();
        } else if (id == R.id.btn_share) {
            mPresenter.showShareDialog(llBillContent);
        }
    }
}
