package com.xxfc.discovery;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.xxfc.discovery.adapter.DiscoveryMenuAdapter;
import com.xxfc.discovery.fragment.RecommendFragment;
import com.xxfc.discovery.presenter.DiscoveryPresenter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

/**
 * 发现模块
 */
public class DiscoveryFragment extends BaseFragment<DiscoveryPresenter>{

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.order_viewPager)
    ViewPager mViewPager;

    private DiscoveryMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    public final static int TYPE_FOR_PAYMENT = 0;//待付款
    public final static int TYPE_TO_TRAVEL = 1;//待出行
    public final static int TYPE_HAVE_TO_TRAVEL = 2;//已出行
    public final static int TYPE_COMPLETED = 3;//已完成
    public final static int TYPE_ALL_ORDER = 4;//全部
    private int menuPosition;

    public static DiscoveryFragment getInstance(int type) {
        Bundle bundl = new Bundle();
        bundl.putInt("type", type);
        DiscoveryFragment fragment = new DiscoveryFragment();
        fragment.setArguments(bundl);
        return fragment;
    }

    @Override
    public int getViewLayout() {
        return R.layout.fragment_discovery;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        initRecyclerView();
        initViewpager();
    }

    @Override
    protected void loadData(Bundle savedInstanceState) {

    }



    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(_mActivity, 4));
        menuAdapter = new DiscoveryMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(5));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
        list.add(_mActivity.getString(R.string.discovery_recommend));
        list.add(_mActivity.getString(R.string.discovery_pat));
        list.add(_mActivity.getString(R.string.discovery_short_video));
        list.add(_mActivity.getString(R.string.discovery_question_and_answer));
        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        });
    }


    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getChildFragmentManager(), getListFragment());
        mViewPager.setAdapter(mAdapter);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(menuPosition);
        mViewPager.setCurrentItem(menuPosition);
    }


    private List<BaseFragment> getListFragment() {
        List<BaseFragment> list = new ArrayList<>();
        list.add(RecommendFragment.getInstance(TYPE_FOR_PAYMENT));
        list.add(RecommendFragment.getInstance(TYPE_TO_TRAVEL));
        list.add(RecommendFragment.getInstance(TYPE_HAVE_TO_TRAVEL));
        list.add(RecommendFragment.getInstance(TYPE_COMPLETED));
        return list;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);
    }

    public SwitchListener switchListener = new SwitchListener() {
        @Override
        public void switchTab(int position) {
            if (menuAdapter != null && mViewPager != null) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        }
    };

    /******
     * 切换事件
     */
    public interface SwitchListener {
        void switchTab(int position);
    }

}
