package com.base.utils.tools.android;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.provider.Settings;
import android.widget.Toast;

import com.base.utils.R;
import com.base.utils.ui.image.crop.CropConstant;

import java.io.File;

/**
 * 意图工具
 * //    1.   ACTION_ACCESSIBILITY_SETTINGS ：    // 跳转系统的辅助功能界面
 * //    2.   ACTION_ADD_ACCOUNT ：               // 显示添加帐户创建一个新的帐户屏幕。【测试跳转到微信登录界面】
 * //    3.   ACTION_AIRPLANE_MODE_SETTINGS：     // 飞行模式，无线网和网络设置界面
 * //    或者：
 * //    ACTION_WIRELESS_SETTINGS  ：
 * //    4.    ACTION_APN_SETTINGS：                                //  跳转 APN设置界面
 * //    5.   【需要参数】 ACTION_APPLICATION_DETAILS_SETTINGS：
 * //    Uri packageURI = Uri.parse("package:" + "com.tencent.WBlog");
 * //    Intent intent =  new Intent(ACTION_APPLICATION_DETAILS_SETTINGS,packageURI);
 * //    startActivity(intent);                                     // 根据包名跳转到系统自带的应用程序信息界面
 * //    6.    ACTION_APPLICATION_DEVELOPMENT_SETTINGS :            // 跳转开发人员选项界面
 * //    7.    ACTION_APPLICATION_SETTINGS ：                       // 跳转应用程序列表界面
 * //    或者：
 * //    ACTION_MANAGE_ALL_APPLICATIONS_SETTINGS                    // 跳转到应用程序界面【所有的】
 * //    或者：
 * //    ACTION_MANAGE_APPLICATIONS_SETTINGS  ：                    // 跳转 应用程序列表界面【已安装的】
 * //    8.    ACTION_BLUETOOTH_SETTINGS  ：                        // 跳转系统的蓝牙设置界面
 * //    9.    ACTION_DATA_ROAMING_SETTINGS ：                      // 跳转到移动网络设置界面
 * //    10.    ACTION_DATE_SETTINGS ：                             // 跳转日期时间设置界面
 * //    11.    ACTION_DEVICE_INFO_SETTINGS  ：                     // 跳转手机状态界面
 * //    12.    ACTION_DISPLAY_SETTINGS  ：                         // 跳转手机显示界面
 * //    13.    ACTION_DREAM_SETTINGS                              【API 18及以上 没测试】
 * //    14.    ACTION_INPUT_METHOD_SETTINGS ：                     // 跳转语言和输入设备
 * //    15.    ACTION_INPUT_METHOD_SUBTYPE_SETTINGS                //【API 11及以上】 跳转 语言选择界面 【多国语言选择】
 * //    16.    ACTION_INTERNAL_STORAGE_SETTINGS                    // 跳转存储设置界面【内部存储】
 * //    或者：
 * //    ACTION_MEMORY_CARD_SETTINGS    ：                          // 跳转 存储设置 【记忆卡存储】
 * //    17.    ACTION_LOCALE_SETTINGS  ：                          // 跳转语言选择界面【仅有English 和 中文两种选择】
 * //    18.     ACTION_LOCATION_SOURCE_SETTINGS :                  // 跳转位置服务界面【管理已安装的应用程序。】
 * //    19.    ACTION_NETWORK_OPERATOR_SETTINGS ：                 // 跳转到 显示设置选择网络运营商。
 * //    20.    ACTION_NFCSHARING_SETTINGS  ：                      // 显示NFC共享设置。 【API 14及以上】
 * //    21.    ACTION_NFC_SETTINGS  ：                             // 显示NFC设置。这显示了用户界面,允许NFC打开或关闭。  【API 16及以上】
 * //    22.    ACTION_PRIVACY_SETTINGS ：                          // 跳转到备份和重置界面
 * //    23.    ACTION_QUICK_LAUNCH_SETTINGS  ：                    // 跳转快速启动设置界面
 * //    24.    ACTION_SEARCH_SETTINGS    ：                        // 跳转到 搜索设置界面
 * //    25.    ACTION_SECURITY_SETTINGS  ：                        // 跳转到安全设置界面
 * //    26.    ACTION_SETTINGS   ：                                // 跳转到设置界面
 * //    27.   ACTION_SOUND_SETTINGS                                // 跳转到声音设置界面
 * //    28.   ACTION_SYNC_SETTINGS ：                              // 跳转账户同步界面
 * //    29.     ACTION_USER_DICTIONARY_SETTINGS ：                 // 跳转用户字典界面
 * //    30.     ACTION_WIFI_IP_SETTINGS  ：                        // 跳转到IP设定界面
 * //    31.     ACTION_WIFI_SETTINGS  ：                           // 跳转Wifi列表设置
 */

public class IntentUtil {
    // 跳转到此App的系统权限设置界面 ，api大于11
    public static void goAppDetailSetting(Context context) {
        Intent localIntent = new Intent();
        addFlags(localIntent);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts("package", context.getPackageName(), null));
        } else {
            localIntent.setAction(Intent.ACTION_VIEW);
            localIntent.setClassName("com.android.settings", "com.android.setting.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", context.getPackageName());
        }
        context.startActivity(localIntent);
    }

    // 跳转到此App的系统权限设置界面 ，api大于11
    public static void goAppDetailSettingNew(Context context) {
        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
        addFlags(intent);
        Uri uri = Uri.fromParts("package", context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    //当Android系统版本低于22就加上             intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    private static void addFlags(Intent intent) {
        if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.LOLLIPOP_MR1) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
    }

    // 跳转到某个ActivityForResult
    public static void startActivityForResult(Activity context, Class<? extends Activity> clazz, int requestCode) {
        Intent intent = new Intent(context, clazz);
        addFlags(intent);
        context.startActivityForResult(intent, requestCode);
    }

    //跳转到系统界面,传入action
    public static void startActivity(Context context, String action) {
        Intent intent = new Intent(action);
        addFlags(intent);
        context.startActivity(intent);
    }

    //跳转到系统的日期设置
    public static void goDateSettings(Context context) {
        Intent intent = new Intent(Settings.ACTION_DATE_SETTINGS);
        addFlags(intent);
        context.startActivity(intent);
    }

    //跳转到系统的移动网络设置
    public static void goRoamingSettings(Context context) {
        Intent intent = new Intent(Settings.ACTION_DATA_ROAMING_SETTINGS);
        addFlags(intent);
        context.startActivity(new Intent(intent));
    }

    //跳转到系统的WiFi设置
    public static void goWiFiSettings(Context context) {
        Intent intent = new Intent(Settings.ACTION_WIFI_SETTINGS);
        addFlags(intent);
        context.startActivity(new Intent(intent));
    }

    //从当前Activity跳转到目标Activity，并在当前Activity上应用动画
    public static void goActivityWithAnimation(Activity currentActivity, Class<? extends Activity> targetActivity) {
        Intent intent = new Intent(currentActivity, targetActivity);
        addFlags(intent);
        currentActivity.startActivity(intent);
        //两个参数分别是新的activity进入的动画和当前activity退出的动画
        currentActivity.overridePendingTransition(R.anim.utils_left_to_right, R.anim.utils_right_to_left);
    }

    //从当前Activity跳转到目标Activity，并在当前Activity上应用动画
    public static void goActivityWithAnimationZoom(Activity currentActivity, Class<? extends Activity> targetActivity) {
        Intent intent = new Intent(currentActivity, targetActivity);
        addFlags(intent);
        currentActivity.startActivity(intent);
        //两个参数分别是新的activity进入的动画和当前activity退出的动画
        currentActivity.overridePendingTransition(R.anim.utils_zoom_in, R.anim.utils_zoom_out);
    }


    //从当前Activity跳转到目标Activity，并在当前Activity上应用动画
    public static void goActivityWithAnimationAlpha(Activity currentActivity, Class<? extends Activity> targetActivity) {
        Intent intent = new Intent(currentActivity, targetActivity);
        addFlags(intent);
        currentActivity.startActivity(intent);
        //两个参数分别是新的activity进入的动画和当前activity退出的动画
        currentActivity.overridePendingTransition(R.anim.utils_alpha_in, R.anim.utils_alpha_out);
    }


    /**
     * 启动一个Activity
     *
     * @param context        from
     * @param targetActivity to
     */
    public static void startActivity(Context context, Class<? extends Activity> targetActivity) {
        Intent intent = new Intent(context, targetActivity);
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * 启动一个Activity
     *
     * @param context        from
     * @param targetActivity to
     * @param extras         Bundle 数据
     */
    public static void startActivity(final Context context, final Class<? extends Activity> targetActivity, final Bundle extras) {
        Intent intent = new Intent(context, targetActivity);
        intent.putExtras(extras);
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * 跳转到拨打电话界面
     */
    public static void dialPhone(Context context, String phoneNumber) {
        Intent intent = new Intent(Intent.ACTION_DIAL);
        Uri data = Uri.parse("tel:" + phoneNumber);
        intent.setData(data);
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * 直接拨打电话
     */
    public static void callPhone(Context context, String phoneNumber) {
        Intent intent = new Intent(Intent.ACTION_CALL);
        Uri data = Uri.parse("tel:" + phoneNumber);
        intent.setData(data);
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * <uses-permission android:name="android.permission.SEND_SMS"></uses-permission>
     * <uses-permission android:name="android.permission.READ_SMS"></uses-permission>
     * <uses-permission android:name="android.permission.RECEIVE_SMS"></uses-permission>
     * 发送短信
     */
    public static void goSMS(Context context, String message) {

        Intent sendIntent = new Intent(Intent.ACTION_VIEW);
        sendIntent.putExtra("sms_body", message);
        sendIntent.setType("vnd.android-dir/mms-sms");
        //sendIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(sendIntent);
    }

    /**
     * <uses-permission android:name="android.permission.SEND_SMS"></uses-permission>
     * <uses-permission android:name="android.permission.READ_SMS"></uses-permission>
     * <uses-permission android:name="android.permission.RECEIVE_SMS"></uses-permission>
     * 发送短信
     */
    public static void goToSMS(Context context, String phoneNumber, String message) {
        //这个方法自动设置接收方的号码
        Uri uri = Uri.parse("smsto:" + phoneNumber);
        Intent sendIntent = new Intent(Intent.ACTION_VIEW, uri);
        //sendIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        sendIntent.putExtra("sms_body", message);
        context.startActivity(sendIntent);
    }

    /**
     * 跳转到浏览器
     */
    public static void goBrowserHttp(Context context, String url) {
        Uri uri = Uri.parse("http://" + url);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * 跳转到浏览器
     */
    public static void goBrowser(Context context, String url) {
        Uri uri = Uri.parse(url);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        addFlags(intent);
        context.startActivity(intent);
    }
/**====================跳转=====================**/


    /**
     * 使用系统相册选择图片
     */
    public static void imageSelect(Activity aty, int requestCode) {
        Intent intent = new Intent(Intent.ACTION_GET_CONTENT, null);
        intent.setType("image/*");
        addFlags(intent);
        aty.startActivityForResult(intent, requestCode);
    }

    /**
     * 使用系统相册选择图片之后裁截取图片
     */
    public static void imageSelectZoom(Activity aty, Uri uri, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(uri, "image/*");
        intent.putExtra("crop", true);
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 300);
        intent.putExtra("return-data", true);
        intent.putExtra("noFaceDetection", true);
        aty.startActivityForResult(intent, requestCode);
    }

    /**
     * 使用系统相册选择图片之后裁截取图片
     *
     * @param inputUri 需要裁剪的图片
     */
    public static void imageCrop(Activity aty, Uri inputUri, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(inputUri, "image/*");
        intent.putExtra("crop", true);
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", CropConstant.IMAGE_CROP_WIDTH);
        intent.putExtra("outputY", CropConstant.IMAGE_CROP_HEIGHT);
        intent.putExtra("return-data", false);
        //intent.putExtra("noFaceDetection", true);
        intent.putExtra(MediaStore.EXTRA_OUTPUT, inputUri);
        aty.startActivityForResult(intent, requestCode);
    }

    /**
     * 选择相机（缩略图）
     */
    public static void imageCameraThumbnail(Activity aty, int request) {
        // 跳转到系统照相机
        Intent cameraIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        addFlags(cameraIntent);
        if (cameraIntent.resolveActivity(aty.getPackageManager()) != null) {
            aty.startActivityForResult(cameraIntent, request);
        }
    }


    /**
     * 选择相机（原图）
     */
    public static void cameraArtwork(Activity aty, String filePath, String imageName, int request) {
        // 跳转到系统照相机
        Intent cameraIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        addFlags(cameraIntent);
        if (cameraIntent.resolveActivity(aty.getPackageManager()) != null) {
            String path = filePath + "/" + imageName + ".png";
            Uri uri = Uri.fromFile(new File(path));
            //为拍摄的图片指定一个存储的路径
            cameraIntent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
            aty.startActivityForResult(cameraIntent, request);
        } else {
            Toast.makeText(aty, aty.getString(R.string.resource_prompt_no_camera), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 播放视频
     *
     * @param context
     * @param videoPath
     */
    public static void goVideoPaly(Context context, String videoPath) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        String bPath = "file://" + videoPath;
        intent.setDataAndType(Uri.parse(bPath), "video/mp4");
        addFlags(intent);
        context.startActivity(intent);
    }

    /**
     * 跳转到微信
     */
    public static void goWeiXin(Context context) {
        try {
            Intent intent = new Intent(Intent.ACTION_MAIN);
            ComponentName cmp = new ComponentName("com.tencent.mm", "com.tencent.mm.ui.LauncherUI");
            intent.addCategory(Intent.CATEGORY_LAUNCHER);
            addFlags(intent);
            intent.setComponent(cmp);
            context.startActivity(intent);
        } catch (ActivityNotFoundException e) {
            Toast.makeText(context, context.getString(R.string.resource_prompt_wx_no_installed), Toast.LENGTH_LONG).show();
        }
    }

    /**
     * 跳转到qq
     *
     * @param qqNumber 和某人的对话
     */
    public static void goQQ(Context context, String qqNumber) {
        try {
            String url = "mqqwpa://im/chat?chat_type=wpa&uin=" + qqNumber;
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            addFlags(intent);
            context.startActivity(intent);
        } catch (ActivityNotFoundException e) {
            Toast.makeText(context, context.getString(R.string.resource_prompt_qq_no_installed), Toast.LENGTH_LONG).show();
        }
    }

    /**
     * 返回到手机桌面
     */
    public static void goHome(Context context) {
        Intent homeIntent = new Intent(Intent.ACTION_MAIN);
        homeIntent.addCategory(Intent.CATEGORY_HOME);
        addFlags(homeIntent);
        context.startActivity(homeIntent);
    }

/**====================安装=====================**/

    /**
     * 检测某个应用是否安装
     *
     * @param context
     * @param packageName
     * @return boolean
     */
    public static boolean isAppInstalled(Context context, String packageName) {
        try {
            context.getPackageManager().getPackageInfo(packageName, 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    /**
     * 启动某App  默认是主页面
     *
     * @param context
     */
    public static void launchApp(Context context, String appPackageName) {
        // 判断是否安装过App，否则去下载
        if (isAppInstalled(context, appPackageName)) {
            context.startActivity(context.getPackageManager().getLaunchIntentForPackage(appPackageName));
        } else {
            //下载
            Toast.makeText(context, context.getString(R.string.resource_prompt_app_no_install), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 启动某App某页面 （方法1）
     * 调用此方法前请注意在 被启动 的App中的AndroidManifest activity 加入 <intent-filter> <action /> 为当前类全名
     *
     * @param context
     */
    public static void launchAppActivity(Context context,
                                         String packageName,
                                         String className,
                                         String classAction) {
        if (isAppInstalled(context, packageName)) {
            Intent intent = new Intent();
            ComponentName comp = new ComponentName(packageName, className);
            intent.setComponent(comp);
            addFlags(intent);
            intent.setAction(classAction);
            context.startActivity(intent);
        } else {
            Toast.makeText(context, context.getString(R.string.resource_prompt_app_no_install), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 启动某App某页面 （方法2）
     * 调用此方法前请注意在 被启动 的App中的AndroidManifest activity 加入 <intent-filter> <action /> 为当前类全名
     *
     * @param context
     */
    public static void launchAppActivity1(Context context, String appPackageName, String appActivityName) {
        if (isAppInstalled(context, appPackageName)) {
            Intent intent = new Intent();
            //包名 包名+类名（全路径）
            addFlags(intent);
            intent.setClassName(appPackageName, appActivityName);
            intent.setAction(appActivityName);
            context.startActivity(intent);
        } else {
            //下载
            Toast.makeText(context, context.getString(R.string.resource_prompt_app_no_install), Toast.LENGTH_SHORT).show();
        }
    }

    /**
     * 安装一个apk
     * 需要new_task
     *
     * @param apkPath apk所在目录的绝对路径  比如imsandroid/imsapp0208.apk
     */
    public static void installApk(Context context, String apkPath) {
        //String fileName = Environment.getExternalStorageDirectory() +"/"+ apkName;
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setDataAndType(Uri.fromFile(new File(apkPath)), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    /**
     * 卸载一个APK
     *
     * @param packageName
     */
    public static void uninstallApk(Context context, String packageName) {
        Uri packageURI = Uri.parse("package:" + packageName);
        Intent uninstallIntent = new Intent(Intent.ACTION_DELETE, packageURI);
        uninstallIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(uninstallIntent);
    }
}
