/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.platform.core.busline;

import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.search.busline.BusLineResult;
import com.baidu.mapapi.search.busline.OnGetBusLineSearchResultListener;
import com.baidu.mapapi.search.core.SearchResult;
import com.baidu.platform.base.d;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class a
extends d {
    @Override
    public SearchResult a(String string) {
        BusLineResult busLineResult = new BusLineResult();
        if (string == null || string.equals("")) {
            busLineResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return busLineResult;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
            if (jSONObject.has("SDK_InnerError")) {
                JSONObject jSONObject2 = jSONObject.optJSONObject("SDK_InnerError");
                if (jSONObject2.has("PermissionCheckError")) {
                    busLineResult.error = SearchResult.ERRORNO.PERMISSION_UNFINISHED;
                    return busLineResult;
                }
                if (jSONObject2.has("httpStateError")) {
                    String string2 = jSONObject2.optString("httpStateError");
                    busLineResult.error = string2.equals("NETWORK_ERROR") ? SearchResult.ERRORNO.NETWORK_ERROR : (string2.equals("REQUEST_ERROR") ? SearchResult.ERRORNO.REQUEST_ERROR : SearchResult.ERRORNO.SEARCH_SERVER_INTERNAL_ERROR);
                    return busLineResult;
                }
            }
        }
        catch (Exception exception) {
            busLineResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
            return busLineResult;
        }
        if (!this.a(string, busLineResult, false) && !this.a(string, busLineResult)) {
            busLineResult.error = SearchResult.ERRORNO.RESULT_NOT_FOUND;
        }
        return busLineResult;
    }

    public boolean a(String string, BusLineResult busLineResult) {
        ArrayList<LatLng> arrayList;
        JSONArray jSONArray;
        if (string == null || "".equals(string)) {
            return false;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
        JSONObject jSONObject2 = jSONObject.optJSONObject("result");
        JSONArray jSONArray2 = jSONObject.optJSONArray("content");
        if (jSONObject2 == null || jSONArray2 == null || jSONArray2.length() <= 0) {
            return false;
        }
        JSONObject jSONObject3 = jSONArray2.optJSONObject(0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        try {
            busLineResult.setStartTime(simpleDateFormat.parse(jSONObject3.optString("startTime")));
            busLineResult.setEndTime(simpleDateFormat.parse(jSONObject3.optString("endTime")));
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        busLineResult.setBusLineName(jSONObject3.optString("name"));
        busLineResult.setMonthTicket(jSONObject3.optInt("isMonTicket") == 1);
        busLineResult.setUid(jSONObject3.optString("uid"));
        busLineResult.setBasePrice((float)jSONObject3.optInt("ticketPrice") / 100.0f);
        busLineResult.setLineDirection(jSONObject3.optString("line_direction"));
        busLineResult.setMaxPrice((float)jSONObject3.optInt("maxPrice") / 100.0f);
        ArrayList<BusLineResult.BusStep> arrayList2 = new ArrayList<BusLineResult.BusStep>();
        List<List<LatLng>> list = CoordUtil.decodeLocationList2D(jSONObject3.optString("geo"));
        if (list != null) {
            jSONArray = list.iterator();
            while (jSONArray.hasNext()) {
                arrayList = (ArrayList<LatLng>)jSONArray.next();
                BusLineResult.BusStep busStep = new BusLineResult.BusStep();
                busStep.setWayPoints(arrayList);
                arrayList2.add(busStep);
            }
        }
        if (arrayList2.size() > 0) {
            busLineResult.setSteps(arrayList2);
        }
        if ((jSONArray = jSONObject3.optJSONArray("stations")) != null) {
            arrayList = new ArrayList<LatLng>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject4 = jSONArray.optJSONObject(i2);
                if (jSONObject4 == null) continue;
                BusLineResult.BusStation busStation = new BusLineResult.BusStation();
                busStation.setTitle(jSONObject4.optString("name"));
                busStation.setLocation(CoordUtil.decodeLocation(jSONObject4.optString("geo")));
                busStation.setUid(jSONObject4.optString("uid"));
                arrayList.add((LatLng)((Object)busStation));
            }
            if (arrayList.size() > 0) {
                busLineResult.setStations(arrayList);
            }
        }
        busLineResult.error = SearchResult.ERRORNO.NO_ERROR;
        return true;
    }

    @Override
    public void a(SearchResult searchResult, Object object) {
        if (null == object || !(object instanceof OnGetBusLineSearchResultListener)) {
            return;
        }
        ((OnGetBusLineSearchResultListener)object).onGetBusLineResult((BusLineResult)searchResult);
    }
}

