package com.rv.plugin.calendar;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import java.util.ArrayList;

/**
 * Created by Sai on 15/11/22.
 */
public class TimePopView extends BasePickerView implements View.OnClickListener {

    WheelTime2 wheelTime;
    private View btnSubmit, btnCancel;
    private TextView tvTitle;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";
    private OnTimeSelectListener timeSelectListener;

    public TimePopView(Context context, ArrayList<String> timeList, OnTimeSelectListener timeSelectListener) {
        super(context);
       this.timeSelectListener = timeSelectListener;

        LayoutInflater.from(context).inflate(R.layout.popview_time2, contentContainer);
        // -----确定和取消按钮
        btnSubmit = findViewById(R.id.btnSubmit);
        btnSubmit.setTag(TAG_SUBMIT);
        btnCancel = findViewById(R.id.btnCancel);
        btnCancel.setTag(TAG_CANCEL);
        btnSubmit.setOnClickListener(this);
        btnCancel.setOnClickListener(this);

        // 顶部标题
        tvTitle = (TextView) findViewById(R.id.tvTitle);

        // ----时间转轮
        final View timepickerview = findViewById(R.id.timepicker);
        wheelTime = new WheelTime2(timepickerview,timeList);

        // 默认选中当前时间
        wheelTime.setPicker(28);
    }

    /**
     * 设置是否循环滚动
     *
     * @param cyclic
     */
    public void setCyclic(boolean cyclic) {
        wheelTime.setCyclic(cyclic);
    }

    public void setCurrentItem(int num)
    {
        wheelTime.setCurrentItem(num);
    }

    @Override
    public void onClick(View v) {
        String tag = (String) v.getTag();
        if (tag.equals(TAG_CANCEL)) {
            dismiss();
            return;
        } else {
            //确定
            if (timeSelectListener != null) {
                timeSelectListener.onTimeSelect(wheelTime.getTime());
            }
            dismiss();
            return;
        }
    }

    public interface OnTimeSelectListener {
       void onTimeSelect(String date);
    }

   /* public void setOnTimeSelectListener(OnTimeSelectListener timeSelectListener) {
        this.timeSelectListener = timeSelectListener;
    }*/

    public void setTitle(String title) {
        tvTitle.setText(title);
    }
}
