package com.rv.rvmine.traveler;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.launcher.ARouter;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.frame.base.url.Constance;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.ui.main.home.bean.DrivingListBean;
import com.rv.home.rv.module.ui.main.home.order.adapter.ForPaymentAdapter;
import com.rv.rvmine.R2;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.rvmine.R;
import com.rv.rvmine.adapter.CollectionAdapter;
import com.rv.rvmine.bean.CollectionListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;

public class CollectionActivity extends BaseStatusActivity<CommonPresenter> implements  BaseQuickAdapter.RequestLoadMoreListener  {
    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    private int mPage;
    private int countPage;

    private CollectionAdapter collectionAdapter;


    public static Intent getIntent(Context context) {
        return new Intent(context, CollectionActivity.class);
    }


    @Override
    protected int setLayout() {
        return R.layout.activity_collection;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
          titleView.setTitle("收藏");

        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        collectionAdapter = new CollectionAdapter(new ArrayList<MultiItemEntity>());
        collectionAdapter.setOnLoadMoreListener(this, recyclerView);
        recyclerView.setAdapter(collectionAdapter);

        collectionAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                CollectionListBean.DataBeanX.DataBean dataBean = (CollectionListBean.DataBeanX.DataBean) adapter.getItem(position);
                if ( 2 == dataBean.getType()) {
                    ARouter.getInstance()
                            .build(Constance.ACTIVITY_URL_TRAVELDETAILS)
                            .withString("id", dataBean.getTypeId())
                            .withString("name", dataBean.getName())
                            .withString("content", dataBean.getUnit())
                            .withString("url", dataBean.getCover())
                            .navigation();
                }else if (1 == dataBean.getType()){

                }
            }
        });
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        onRefresh();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        processData((CollectionListBean) result);
    }

    @Override
    public void onLoadMoreRequested() {

        if (mPage >= countPage) {
            collectionAdapter.loadMoreEnd();
        } else {
            mPage++;
            getDrivingList(mPage);
        }
    }


    /**
     * 刷新数据
     */
    private void onRefresh() {
        mPage = 1;
        getDrivingList(mPage);
    }


    /**
     * 获取收藏列表
     */
    private void getDrivingList(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        mPresenter.getData(RvFrameConfig.ADMIN_POST, 0, ApiConfig.HTTP_URL_COLLECTONLIST, CollectionListBean.class, map,headMap, page == 1 ? true : false);
    }


    private void processData(CollectionListBean bean) {
        if (mPage == 1) {
            if (bean.getData().getTotalCount() == 0) {
                collectionAdapter.setEmptyView(getEmptyView(recyclerView, -1, mActivity.getString(R.string.rv_collection_data_null)));
                return;
            }

            countPage = bean.getData().getTotalPage();
            collectionAdapter.addNewData(bean);
            collectionAdapter.loadMoreComplete();
        } else {
            collectionAdapter.addData(bean.getData().getData());
            collectionAdapter.loadMoreComplete();
        }
    }

}
