package com.rv.home.rv.module.ui.main.home.order;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.TimeManager;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.rv.home.rv.module.basic.presenter.PickerPresenter;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;

import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * 取车二维码
 */
public class PickUpTheCarQRCodeActivity extends BaseStatusActivity<PickerPresenter> {

    @BindView(R2.id.tv_center)
    TextView tvCenter;
    @BindView(R2.id.lay_title)
    RelativeLayout layTitle;
    @BindView(R2.id.iv_goods)
    ImageView ivGoods;
    @BindView(R2.id.tv_car_type)
    TextView tvCarType;
    @BindView(R2.id.tv_get_time)
    TextView tvGetTime;
    @BindView(R2.id.tv_get_address)
    TextView tvGetAddress;
    @BindView(R2.id.ll_get)
    LinearLayout llGet;
    @BindView(R2.id.tv_out_time)
    TextView tvOutTime;
    @BindView(R2.id.tv_out_address)
    TextView tvOutAddress;
    @BindView(R2.id.ll_out)
    LinearLayout llOut;
    @BindView(R2.id.tv_price)
    TextView tvPrice;
    @BindView(R2.id.iv_zxing)
    ImageView ivZxing;

    private OrderListBean.DataBeanX.DataBean dataBean;


    public static Intent getIntent(Context context, OrderListBean.DataBeanX.DataBean dataBean) {
        return new Intent(context, PickUpTheCarQRCodeActivity.class)
                .putExtra("dataBean", dataBean);
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_pick_up_the_car_qrcode;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        dataBean = (OrderListBean.DataBeanX.DataBean) intent.getSerializableExtra("dataBean");

        if (dataBean != null){
            if (4==dataBean.getStatusX()){
                tvCenter.setText("出示取车二维码");
            }else if (5==dataBean.getStatusX()){
                tvCenter.setText("出示还车二维码");
            }
            tvCarType.setText(dataBean.getName());
            OrderListBean.DataBeanX.DataBean.OrderRentVehicleDetail detail = dataBean.getOrderRentVehicleDetail();
            if (detail !=null){
                tvGetAddress.setText(detail.getStart_addr());
                tvGetTime.setText(TimeManager.stampToDate(String.valueOf(detail.getStart_time())));
                tvOutAddress.setText(detail.getEnd_addr());
                tvOutTime.setText(TimeManager.stampToDate(String.valueOf(detail.getEnd_time())));
                tvPrice.setText(String.format("￥%1$s", dataBean.getOrderAmount()));
                GlideManager.getInstance(mActivity).loadImage(dataBean.getPicture(), ivGoods);
            }
        }

        //生成带中间图标的二维码
        Bitmap success =createQRImage("33333333333333333333333", 100, 100,
                BitmapFactory.decodeResource(getResources(), R.mipmap.ic_launcher));
        ivZxing.setImageBitmap(success);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }

    @OnClick({R2.id.iv_back, R2.id.iv_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.iv_customer_service) {
            showToast("该功能还在开发中...");
        }
    }

    public static Bitmap createQRImage(String content, int widthPix, int heightPix,
                                       Bitmap logoBm) {
        try {
            //配置参数
            Map<EncodeHintType, Object> hints = new HashMap<>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            //容错级别
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            //设置空白边距的宽度
            hints.put(EncodeHintType.MARGIN, 1); //default is 4

            // 图像数据转换，使用了矩阵转换
            BitMatrix bitMatrix = null;
            try {
                bitMatrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, widthPix,
                        heightPix, hints);
            } catch (WriterException e) {
                e.printStackTrace();
            }
            int[] pixels = new int[widthPix * heightPix];
            // 下面这里按照二维码的算法，逐个生成二维码的图片，
            // 两个for循环是图片横列扫描的结果
            for (int y = 0; y < heightPix; y++) {
                for (int x = 0; x < widthPix; x++) {
                    if (bitMatrix.get(x, y)) {
                        pixels[y * widthPix + x] = 0xff000000;
                    } else {
                        pixels[y * widthPix + x] = 0xffffffff;
                    }
                }
            }

            // 生成二维码图片的格式，使用ARGB_8888
            Bitmap bitmap = Bitmap.createBitmap(widthPix, heightPix, Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, widthPix, 0, 0, widthPix, heightPix);

            if (logoBm != null) {
                bitmap = Logo(bitmap, logoBm);
            }

            //必须使用compress方法将bitmap保存到文件中再进行读取。直接返回的bitmap是没有任何压缩的，
            // 内存消耗巨大！
            return bitmap;
//            return bitmap != null && bitmap.compress(Bitmap.CompressFormat.JPEG, 100);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    private static Bitmap Logo(Bitmap src, Bitmap logo) {
        if (src == null) {
            return null;
        }

        if (logo == null) {
            return src;
        }

        //获取图片的宽高
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();

        if (srcWidth == 0 || srcHeight == 0) {
            return null;
        }

        if (logoWidth == 0 || logoHeight == 0) {
            return src;
        }

        //logo大小为二维码整体大小的1/5
        float scaleFactor = srcWidth * 1.0f / 5 / logoWidth;
        Bitmap bitmap = Bitmap.createBitmap(srcWidth, srcHeight, Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0, 0, null);
            canvas.scale(scaleFactor, scaleFactor, srcWidth / 2, srcHeight / 2);
            canvas.drawBitmap(logo, (srcWidth - logoWidth) / 2, (srcHeight - logoHeight) / 2, null);

            canvas.save();
            canvas.restore();
        } catch (Exception e) {
            bitmap = null;
            e.getStackTrace();
        }

        return bitmap;
    }
}
