package com.rv.home.rv.module.ui.main.home.adapter;

import android.widget.ImageView;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.bean.HomeHotGoodListBean;
import com.rv.home.rv.module.ui.main.home.bean.HomePopularBrigade;

/**
 * Created :Auser
 * Date: 2019/5/17.
 * Desc:热门车型适配
 */

public class HotCarTypeAdapter extends BaseQuickAdapter<HomeHotGoodListBean.DataBean,BaseGlideHolder>{
    public HotCarTypeAdapter() {
        super(R.layout.rv_item_hot_car_type);
    }

    @Override
    protected void convert(BaseGlideHolder helper, HomeHotGoodListBean.DataBean bean) {
        helper.loadRoundImage(mContext,bean.getImgUrl(), (ImageView) helper.getView(R.id.iv_goods),6);
        helper.setText(R.id.tv_name,bean.getName());
        helper.setText(R.id.tv_content,bean.getName1());
        if (!TextUtil.isEmpty(bean.getPrice())) {
            helper.setText(R.id.tv_price, String.format("¥%1$s%2$s", bean.getPrice(), mContext.getString(R.string.rv_day)));
        }else {
            helper.setText(R.id.tv_price,"");
        }
    }


//    @Override
//    public int getItemCount() {
//        return 4;
//    }
}
