package com.rv.home.rv.module.ui.main.home;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.rv.home.R;
import com.rv.home.R2;
import com.rv.home.rv.module.basic.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;

import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.adapter.DrivingListAdapter;
import com.rv.home.rv.module.ui.main.home.bean.DrivingListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import butterknife.BindView;

public class DrivingListActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener {
    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    private DrivingListAdapter mAdapter;

    private final int TYPE_REQUEST_ADD = 1;
    private final int TYPE_REQUEST_EDIT = 2;
    private int mPage;
    private int countPage;
    private DrivingListBean.DataBeanX.DataBean dataBean;

    public static Intent getIntent(Context context, DrivingListBean.DataBeanX.DataBean dataBean) {
        return new Intent(context, DrivingListActivity.class)
                .putExtra("data", dataBean);
    }

    ;

    @Override
    protected int setLayout() {
        return R.layout.rv_act_driving_list;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle(mActivity.getString(R.string.rv_driving));
        dataBean = (DrivingListBean.DataBeanX.DataBean) intent.getSerializableExtra("data");
        titleView.setImageResource(R.id.iv_title_right, R.drawable.rv_common_icon_thestaff);
        titleView.setChildClickListener(R.id.iv_title_right, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivityForResult(DrivingUploadActivity.getIntent(mActivity, null), TYPE_REQUEST_ADD);
            }
        });

        mAdapter = new DrivingListAdapter();
        mAdapter.setOnLoadMoreListener(this, recyclerView);
        recyclerView.setLayoutManager(new LinearLayoutManager(mActivity));
        recyclerView.setAdapter(mAdapter);
        mAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                getIntent().putExtra("bean", mAdapter.getItem(position));
                setResult(RESULT_OK, getIntent());
                finish();
            }
        });

        mAdapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener() {
            @Override
            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                if (view.getId() == R.id.tv_edit) {
                    startActivityForResult(DrivingUploadActivity.getIntent(mActivity, mAdapter.getItem(position)), TYPE_REQUEST_ADD);
                }
            }
        });
    }


    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        onRefresh();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        processData((DrivingListBean) result);
    }

    @Override
    public void onLoadMoreRequested() {

        if (mPage >= countPage) {
            mAdapter.loadMoreEnd();
        } else {
            mPage++;
            getDrivingList(mPage);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            switch (requestCode) {
                case TYPE_REQUEST_ADD:
                case TYPE_REQUEST_EDIT:
                    onRefresh();
                    break;
            }
        }
    }

    /**
     * 获取驾驶员列表
     */
    private void getDrivingList(int page) {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null)
            headMap.put("Authorization", OkGoUtil.getToken());
        Map<String, Object> map = new LinkedHashMap<>();
        map.put("page", page);
        mPresenter.postData(RvFrameConfig.VEHICLE_CAR_POST, 0, ApiConfig.HTTP_URL_DRIVING_LIST, DrivingListBean.class, map, headMap, page == 1 ? true : false);
    }

    /**
     * 刷新数据
     */
    private void onRefresh() {
        mPage = 1;
        getDrivingList(mPage);
    }

    private void processData(DrivingListBean bean) {
        if (mPage == 1) {
            if (bean.getData().getTotalCount() == 0) {
                mAdapter.setEmptyView(getEmptyView(recyclerView, -1, mActivity.getString(R.string.rv_driving_data_null)));
                return;
            }

            if (bean.getData() != null && bean.getData().getData().size() > 0) {
                for (int i = 0; i < bean.getData().getData().size(); i++) {
                    if (dataBean != null) {
                        if (dataBean.getId() == bean.getData().getData().get(i).getId()) {
                             bean.getData().getData().get(i).setCheck(true);
                        }
                    }
                }
            }
            countPage = bean.getData().getTotalPage();
            mAdapter.setNewData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        } else {
            mAdapter.addData(bean.getData().getData());
            mAdapter.loadMoreComplete();
        }
    }

}
