package com.base.utils.ui.refresh.anim.simple.activity;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.Toast;

import com.base.utils.R;
import com.base.utils.ui.refresh.anim.simple.fragment.GridFragment;
import com.base.utils.ui.refresh.anim.simple.fragment.LinearFragment;
import com.base.utils.ui.refresh.anim.simple.fragment.StaggeredGridFragment;
import com.base.utils.ui.datetime.selector.TimeSelector;


/**
 * 动画刷新演示
 */
public class SampleAnimRefreshActivity extends AppCompatActivity{

    private LinearFragment listFragment;
    private GridFragment gridFragment;
    private StaggeredGridFragment staggeredGridFragment;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sample_activity_anim_refresh);

        listFragment = new LinearFragment();
        gridFragment = new GridFragment();
        staggeredGridFragment = new StaggeredGridFragment();

        getFragmentManager().beginTransaction().replace(R.id.fragment_container, listFragment).commit();


    }

    public void onAnimRefreshClick(View v) {
        int i = v.getId();
        if (i == R.id.list) {
            getFragmentManager().beginTransaction().replace(R.id.fragment_container, listFragment).commit();
        } else if (i == R.id.grid) {
            getFragmentManager().beginTransaction().replace(R.id.fragment_container, gridFragment).commit();
        } else if (i == R.id.staggered_grid) {
            getFragmentManager().beginTransaction().replace(R.id.fragment_container, staggeredGridFragment).commit();
        }
    }
}
