package com.base.utils.tools.java;

import com.base.utils.tools.android.LogUtil;

import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日期工具
 */
public class DateUtil {
//        2006年11月17日 15时19分56秒
//        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分ss秒");
//        06/11/17 15:19
//        SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm");
//        2006-11-17 15:19:56
//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        2006年11月17日 15时19分56秒 星期五
//        SimpleDateFormat myFmt3 = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分ss秒 E ");
//    //获取当前系统时间
//    //方法一
//    long startMillis=System.currentTimeMillis();
//    //方法二
//    long startTimeInMillis=Calendar.getInstance().getTimeInMillis();
//    //方法三
//    long startGetTime=new Date().getTime();

    public interface OnInternetTimeListener {
        void done(Date date, Exception e);
    }

    /**
     * 获取百度官方时间
     */
    public static void getBaiduTime(final OnInternetTimeListener listener) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                String webUrlBaidu = "http://www.baidu.com";//百度
                URL url = null;// 取得资源对象
                try {
                    url = new URL(webUrlBaidu);
                    URLConnection uc = url.openConnection();// 生成连接对象
                    uc.connect();// 发出连接
                    long ld = uc.getDate();// 读取网站日期时间
                    Date date = new Date(ld);// 转换为标准时间对象
                    //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);// 输出北京时间
                    listener.done(date, null);
                } catch (Exception e) {
                    e.printStackTrace();
                    LogUtil.err(DateUtil.class, "Exception:" + e.getMessage());
                    listener.done(null, e);
                }
            }
        }).start();


    }

    /**
     * 获取淘宝官方时间
     */
    public static void getTaobaoTime(final OnInternetTimeListener listener) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                String webUrlTaobao = "http://www.taobao.com";//淘宝
                URL url = null;// 取得资源对象
                try {
                    url = new URL(webUrlTaobao);
                    URLConnection uc = url.openConnection();// 生成连接对象
                    uc.connect();// 发出连接
                    long ld = uc.getDate();// 读取网站日期时间
                    Date date = new Date(ld);// 转换为标准时间对象
                    //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);// 输出北京时间
                    listener.done(date, null);
                } catch (Exception e) {
                    e.printStackTrace();
                    LogUtil.err(DateUtil.class, "Exception:" + e.getMessage());
                    listener.done(null, e);
                }
            }
        }).start();


    }

    /**
     * 以现在为标准，向后推延指定month的数量
     *
     * @param months 向后推延的月数
     * @return String[], 0下标是年，1下标是月，2下标是日
     */
    public static int[] getDateByMonths(int months) {
        return getDateByMonths(getYearInt(), getMonthInt(), getDayInt(), months);
    }

    /**
     * 以某个日期为标准，向后推延指定month的数量
     *
     * @param targetYear  指定年份
     * @param targetMonth 指定月
     * @param targetDay   指定日
     * @param months      向后推延的月数
     * @return String[], 0下标是年，1下标是月，2下标是日
     */
    public static int[] getDateByMonths(int targetYear, int targetMonth, int targetDay, int months) {
        int mYear = targetYear;
        int sumMonth = targetMonth + months;
        if (sumMonth > 12) {
            int newYear = sumMonth / 12;
            mYear += newYear;
        }
        int finalMonth = sumMonth % 12;
        if (finalMonth == 0) {
            return new int[]{mYear, 12, targetDay};
        } else {
            return new int[]{mYear, finalMonth, targetDay};
        }
    }

    /**
     * @param time 某个时间
     * @return String yyyy年MM月dd日 HH时mm分ss秒
     * yyyy-MM-dd HH:mm:ss
     * yy/MM/dd HH:mm
     */
    public static String parseTimeYYYYMMDDHHMMSS(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(time));
    }

    /**
     * @param time 某个时间
     * @return String yyyy年MM月dd日 HH时mm分ss秒
     * yyyy-MM-dd HH:mm:ss
     * yy/MM/dd HH:mm
     */
    public static String parseTimeYYYYMMDD(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date(time));
    }

    /**
     * 指定格式返回当前系统时间
     *
     * @param format yyyy年MM月dd日 HH时mm分ss秒
     *               yyyy-MM-dd HH:mm:ss
     *               yy/MM/dd HH:mm
     *               等等
     */
    public static String getDataTime(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date());
    }

    /**
     * 得到当前年
     */
    public static int getYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String currentTime = sdf.format(System.currentTimeMillis());
        return Integer.parseInt(currentTime);
    }

    /**
     * 得到当前年
     *
     * @return int
     */
    public static int getYearInt() {
        return Integer.parseInt(getYearString());
    }

    /**
     * 得到当前年
     *
     * @return String
     */
    public static String getYearString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String currentTime = sdf.format(System.currentTimeMillis());
        return currentTime;
    }

    /**
     * 得到当前月份 int
     */
    public static int getMonthInt() {
        return Integer.parseInt(getMonthString());
    }

    /**
     * 得到当前月份 string
     */
    public static String getMonthString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentTime = sdf.format(System.currentTimeMillis());
        String month = currentTime.substring(5, 7);
        return month;
    }

    /**
     * 得到今天日期 int
     */
    public static int getDayInt() {
        return Integer.parseInt(getDayString());
    }

    /**
     * 得到今天日期 string
     */
    public static String getDayString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentTime = sdf.format(System.currentTimeMillis());
        String day = currentTime.substring(8, currentTime.length());
        return day;
    }


    /**
     * 得到某天日期 String
     * "yyyy-MM-dd HH:mm:ss"
     */
    public static String getYYYYMMDDHHMMSS(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentTime = sdf.format(time);
        return currentTime;
    }

    /**
     * 得到某天日期 String
     * "yyyyMMddHHmmss"
     */
    public static String getTodayYYYYMMDDHHMMSS() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String currentTime = sdf.format(System.currentTimeMillis());
        return currentTime;
    }

    /**
     * 得到某天日期 String
     * "yyyy-MM-dd"
     * * @param time 后面比php多3个0
     */
    public static String getDateYYYYMMDD_java(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentTime = sdf.format(time);
        return currentTime;
    }

    /**
     * 得到某天日期 String
     * "yyyy-MM-dd"
     * * @param time 后面要补3个0
     */
    public static String getDateYYYYMMDD_php(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String currentTime = sdf.format(Long.valueOf(time + "000"));
        return currentTime;
    }

    /**
     * 得到某天日期 String
     * "yyyy-MM-dd"
     * * @param time 后面要补3个0
     */
    public static String getDateYYYYMMDDHHMM_php(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String currentTime = sdf.format(Long.valueOf(time + "000"));
        return currentTime;
    }

    /**
     * 得到某天日期 long
     * "yyyy-MM-dd"
     * * @param time 为"yyyy-MM-dd"的格式
     */
    public static long getDateByYYYYMMDD_java(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(time);
            return date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 得到某天日期 long
     * "yyyy-MM-dd"
     * * @param time 为"yyyy-MM-dd"的格式
     */
    public static long getDayDateByYYYYMMDDHHMM_java(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            Date date = sdf.parse(time);
            return date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }
    /**
     * 得到某天日期 long
     * "yyyy-MM-dd"
     * * @param time 为"yyyy-MM-dd"的格式
     */
    public static long getDayDateByYYYYMMDD_java(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(time);
            return date.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 得到某天日期 long
     * "yyyy-MM-dd"
     *
     * @param time 为"yyyy-MM-dd"的格式
     */
    public static long getDateByYYYYMMDD_php(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(time);
            String stringTime = String.valueOf(date.getTime());
            return Long.valueOf(stringTime.substring(0, stringTime.length() - 3));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 得到某天日期 long
     * "yyyy-MM-dd"
     * * @param time 为"yyyy-MM-dd"的格式
     */
    public static long getDayDateByYYYYMMDDHHMM_php(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        try {
            Date date = sdf.parse(time);
            String stringTime = String.valueOf(date.getTime());
            return Long.valueOf(stringTime.substring(0, stringTime.length() - 3));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /**
     * 得到今天日期 String
     * "yyyy-MM-dd"
     */
    public static String getTodayYYYYMMDD() {
        return getDateYYYYMMDD_java(System.currentTimeMillis());
    }

    /**
     * 得到今天日期 String
     * "yyMMdd"
     */
    public static String getTodayYYMMDD() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
        String currentTime = sdf.format(System.currentTimeMillis());
        return currentTime;
    }


    /**
     * 返回指定年指定月份的天数
     *
     * @param year,month 指定年，指定月
     */
    public static int getMonthDays(int year, int month) {
        if (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) {
            // 这是闰年
            if (month == 1 || month == 3 || month == 5 || month == 7
                    || month == 8 || month == 10 || month == 12) {
                // 31
                return 31;

            } else if (month == 4 || month == 6 || month == 9 || month == 11) {
                // 30
                return 30;
            } else if (month == 2) {
                // 2月 29天
                return 29;
            }
        } else {
            // 这是平年
            if (month == 1 || month == 3 || month == 5 || month == 7
                    || month == 8 || month == 10 || month == 12) {
                // 31
                return 31;

            } else if (month == 4 || month == 6 || month == 9 || month == 11) {
                // 30
                return 30;
            } else {
                // 2月 28天
                return 28;
            }
        }

        return 0;
    }


    public static final int WEEKDAYS = 7;
    public static String[] WEEK_STRING = {"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
    public static int[] WEEK_INT = {0, 1, 2, 3, 4, 5, 6};

    /**
     * 日期变量转成对应的星期字符串
     *
     * @param date 日期对象
     * @return String 星期几
     */
    public static String dayOfWeekString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(Calendar.DAY_OF_WEEK);
        if (dayIndex < 1 || dayIndex > WEEKDAYS) {
            return null;
        }
        return WEEK_STRING[dayIndex - 1];
    }

    /**
     * 日期变量转成对应的星期字符串
     *
     * @param date 日期对象
     * @return int 返回-1时，说明传递的参数有错 正常是0，1，2，3，4，5，6
     */
    public static int dayOfWeekInt(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(Calendar.DAY_OF_WEEK);
        if (dayIndex < 1 || dayIndex > WEEKDAYS) {
            return -1;
        }
        return WEEK_INT[dayIndex - 1];
    }

    /**
     * 判断一个日期和现在隔了多少天
     *
     * @param targetDate 指定日期 格式为："yyyy-MM-dd HH:mm:ss"
     */
    public static long getBeApartDay(String targetDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date before = sdf.parse(targetDate);

        String nowString = sdf.format(System.currentTimeMillis());
        Date now = sdf.parse(nowString);

        long day = Math.abs(now.getTime() - before.getTime()) / (24 * 60 * 60 * 1000);
        if (before.getTime() < now.getTime()) {
            day = day - (day * 2);
        }

        return day;
    }

    /**
     * 判断一个日期和现在隔了多少小时
     *
     * @param targetDate 指定日期 格式为："yyyy-MM-dd HH:mm:ss"
     */
    public static long getBeApartHours(String targetDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date before = sdf.parse(targetDate);

        String nowString = sdf.format(System.currentTimeMillis());
        Date now = sdf.parse(nowString);

        long hours = (now.getTime() - before.getTime()) / (60 * 60 * 1000);
        return hours;
    }

    /**
     * 判断一个日期和现在隔了多少分种
     *
     * @param targetDate 指定日期 格式为："yyyy-MM-dd HH:mm:ss"
     */
    public static long getBeApartMinute(String targetDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date before = sdf.parse(targetDate);

        String nowString = sdf.format(System.currentTimeMillis());
        Date now = sdf.parse(nowString);

        long minute = (now.getTime() - before.getTime()) / (60 * 1000);
        return minute;
    }


    /**
     * 判断两个日期隔了多少天
     *
     * @param start 开始日期
     * @param end   结束日期
     */
    public static long getTwoDatesBeApart(String start, String end) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date before = sdf.parse(start);
        Date now = sdf.parse(end);
        long day = (now.getTime() - before.getTime()) / (24 * 60 * 60 * 1000);
        return day;
    }

    /**
     * 转换成  查日报列表所要的时间
     *
     * @param formatString 制定返回的格式 如"yyyy-MM-dd"
     * @param year         年
     * @param month        月
     * @param day          日
     */
    public static String getDate(String formatString, int year, int month, int day) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatString);
        Date date = new Date();
        date.setYear(year - 1900);
        date.setMonth(month - 1);
        date.setDate(day);
        return dateFormat.format(date);
    }

}
