package com.rv.travel.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.base.animset.util.NiftyEffects;
import com.base.utils.base.BaseFragment;
import com.base.utils.tools.android.IntentUtil;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.base.browse.ActivityImageBrowseUrl;
import com.frame.rv.widget.BaseTipsLayout;
import com.rv.travel.GoOtherUtil;
import com.rv.travel.R;
import com.rv.travel.R2;
import com.rv.travel.TravelActivity;
import com.rv.travel.adapter.AdapterHot;
import com.rv.travel.adapter.AdapterRim;
import com.rv.travel.api.ApiUtil;
import com.rv.travel.api.OnApiResponseCallback;
import com.rv.travel.bean.BeanBanner;
import com.rv.travel.bean.BeanHot;
import com.rv.travel.bean.BeanRim;
import com.yuyife.banner.Banner;
import com.yuyife.banner.BannerConfig;
import com.yuyife.banner.listener.OnBannerListener;
import com.yuyife.banner.loader.ImageLoader;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.Unbinder;

//主页面
public class TravelFragmentMain extends BaseFragment {
    @BindView(R2.id.travel_banner)
    Banner banner;
    @BindView(R2.id.travel_hot_recycler)
    RecyclerView hotRecycler;
    @BindView(R2.id.travel_rim_recycler)
    RecyclerView rimRecycler;
    @BindView(R2.id.travel_fragment_hot_more_layout)
    FrameLayout hotMoreLayout;
    @BindView(R2.id.query_layout)
    LinearLayout queryLayout;
    @BindView(R2.id.travel_hot_tips)
    BaseTipsLayout hotTips;
    @BindView(R2.id.travel_rim_tips)
    BaseTipsLayout rimTips;

    @SuppressLint("StaticFieldLeak")
    public static FrameLayout hotMoreLayoutStatic;

    @OnClick({R2.id.travel_hot_more_image
    })
    public void onTravelFragmentMainClick(View view) {
        int id = view.getId();
        if (id == R.id.travel_hot_more_image) {
            NiftyEffects.jelly.getAnimator().in(view);
            setHotMoreFragment();
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_travel_mian, container, false);
        unbinder = ButterKnife.bind(this, view);
        return view;
    }

    Unbinder unbinder;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        hotMoreLayoutStatic = hotMoreLayout;
        hideHotMoreFragment();
        onData();
        onView();
    }


    @Override
    public void onData() {

        setHot();

        query = "";
        isQueryMode = false;
        setRim();
    }

    @Override
    public void onView() {

        setBanner();


        ApiUtil.getCompanyData("2", new OnApiResponseCallback<List<BeanBanner>, String>() {
            @Override
            public void done(List<BeanBanner> data, String errorMessage) {

            }
        });


    }

    private AdapterHot adapterHot;

    private void setHot() {
        hotTips.setVisibility(View.VISIBLE);

        List<BeanHot> data = new ArrayList<>();
        adapterHot = new AdapterHot(R.layout.item_travel_hot, data);
        adapterHot.setOnItemRootClickListener(new AdapterHot.OnItemRootClickListener() {
            @Override
            public void onItemClick(BeanHot bean) {

                TravelActivity.getInstance().setTravelFragmentHotType(bean);
            }
        });
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(baseContext);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        hotRecycler.setLayoutManager(linearLayoutManager);
        hotRecycler.setAdapter(adapterHot);
        ApiUtil.getHotData("1", "1", "50", new OnApiResponseCallback<List<BeanHot>, String>() {
            @Override
            public void done(List<BeanHot> data, String errorMessage) {
                adapterHot.setNewData(data);
                hotTips.setData(data);
            }
        });
    }

    private AdapterRim adapterRim;

    private void setRim() {

        rimTips.setVisibility(View.VISIBLE);
        List<BeanRim> data = new ArrayList<>();
        adapterRim = new AdapterRim(R.layout.item_travel_rim, data);
        adapterRim.setItemRootClickListener(new AdapterRim.OnItemRootClickListener() {
            @Override
            public void onItemClick(BeanRim bean) {
                GoOtherUtil.goTravelDetailWeb(bean,baseContext);
            }
        });
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(baseContext);
        linearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);
        rimRecycler.setLayoutManager(linearLayoutManager);
        rimRecycler.setAdapter(adapterRim);

        ApiUtil.getRimData("", query, "1", "50", new OnApiResponseCallback<List<BeanRim>, String>() {
            @Override
            public void done(List<BeanRim> data, String errorMessage) {
                adapterRim.setNewData(data);
                rimTips.setData(data);
            }
        });

        if (isQueryMode) {
            queryLayout.setVisibility(View.GONE);
        } else {
            queryLayout.setVisibility(View.VISIBLE);
        }
    }

    private String query = "";
    private boolean isQueryMode = false;

    public void getRimData(String queryInput) {
        query = queryInput;
        isQueryMode = !TextUtil.isEmpty(query);
        setRim();
    }


    private ArrayList<String> images = new ArrayList<>();    //图片(默认采用网络地址)
    private List<String> titles = new ArrayList<>();         //图片标题
    //private List<Integer> localImages = new ArrayList<>();   //图片(本地资源)

    private void setBanner() {
        titles.clear();
        images.clear();
        //localImages.clear();

        ApiUtil.getBannerDataMain(new OnApiResponseCallback<List<BeanBanner>, String>() {
            @Override
            public void done(List<BeanBanner> bannerData, String errorMessage) {
                if (bannerData != null && bannerData.size() > 0) {
                    for (BeanBanner bean : bannerData) {
                        images.add(bean.getCover());
                        titles.add("");
                    }
                }
                banner.isAutoPlay(true)
                        .setBannerTitles(titles)
                        .setImages(images)
                        .setDelayTime(3000)
                        .setImageLoader(new ImageLoader() {
                            @Override
                            public void displayImage(Context context, Object path, ImageView imageView) {

//                                GlideManager.getInstance(context).loadImage(path, imageView);
                            }
                        })
                        .setOnBannerListener(new OnBannerListener() {
                            @Override
                            public void OnBannerClick(int position) {

                                Bundle bundle = new Bundle();
                                bundle.putInt(ActivityImageBrowseUrl.KEY_BACKGROUND, R.color.colorPrimary);
                                bundle.putStringArrayList(ActivityImageBrowseUrl.KEY_IMAGE, (ArrayList<String>) images);
                                IntentUtil.startActivity(baseContext, ActivityImageBrowseUrl.class, bundle);

                            }
                        })
                        .start();

                banner.updateBannerStyle(BannerConfig.CIRCLE_INDICATOR);
            }
        });

    }


    private TravelFragmentHotMore travelFragmentHotMore;

    private void setHotMoreFragment() {
        TravelActivity.hotMoreTitleLayoutStatic.setVisibility(View.VISIBLE);
        hotMoreLayoutStatic.setVisibility(View.VISIBLE);

        if (travelFragmentHotMore == null) {
            travelFragmentHotMore = TravelFragmentHotMore.getInstance(TravelFragmentMain.class.getSimpleName());
        }
        getChildFragmentManager().beginTransaction().replace(R.id.travel_fragment_hot_more_layout, travelFragmentHotMore).commitAllowingStateLoss();

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        hotMoreLayoutStatic = null;
    }

    public static void hideHotMoreFragment() {
        TravelActivity.hotMoreTitleLayoutStatic.setVisibility(View.GONE);
        hotMoreLayoutStatic.setVisibility(View.GONE);

    }
}
