package com.xxfc.rv;


import android.app.Activity;

import com.alibaba.android.arouter.launcher.ARouter;
import com.baidu.mapapi.CoordType;
import com.baidu.mapapi.SDKInitializer;
import com.base.utils.Config;
import com.base.utils.CrashHandler;
import com.base.utils.eventbusmodel.EventMimcRouse;
import com.base.utils.eventbusmodel.EventNoActivity;
import com.base.utils.eventbusmodel.EventRestartApp;
import com.frame.base.FrameApp;
import com.frame.base.bean.BeanHeartbeat;
import com.frame.base.manager.MyFrameManager;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.util.LogUtils;
import com.tencent.bugly.crashreport.CrashReport;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.socialize.PlatformConfig;
import com.yuyife.okgo.OkGoUtil;

import java.util.Locale;

import cn.pedant.SweetAlert.SweetAlertDialog;
import me.jessyan.autosize.AutoSize;
import me.jessyan.autosize.AutoSizeConfig;
import me.jessyan.autosize.onAdaptListener;

/**
 * Created :Auser
 * Date: 2019/5/22.
 * Desc:
 */

public class RvClientApplication extends FrameApp {
    final public static String token = "eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiIxMzc2NjY2NjY2NiIsInVzZXJJZCI6IjE1IiwicmVxdWVzdFR5cGUiOiJBUFAiLCJleHAiOjE1NTk4MDU4Mjd9.NAzU25an3hqrbQI2dsroONtckMmQZRUikqBXxThGRQb578Adq7lQKM-jPw2ViCuXUcGuNRPG47d1hCzyRZH_-8nkG2ls7F0zRMATbcWIL0fozLKS4puMYT_I359JIdp_a6onEmfX0RMunupp0tbRlrbdaVLIIXIvA4nU8b_b4Rc";
    //ARouter 调试开关
    private boolean isDedugARouter = true;

    @Override
    public void onCreate() {
        super.onCreate();
        CrashHandler.getInstance().init(this);
        // 在使用 SDK 各组间之前初始化 context 信息，传入 ApplicationContext
        SDKInitializer.initialize(this);
        //自4.3.0起，百度地图SDK所有接口均支持百度坐标和国测局坐标，用此方法设置您使用的坐标类型.
        //包括BD09LL和GCJ02两种坐标，默认是BD09LL坐标。
        SDKInitializer.setCoordType(CoordType.BD09LL);
        initUM();
        //初始化bugly
        CrashReport.initCrashReport(getApplicationContext(), "82ebaf448b", false);
        //初始化AutoSize
        initAuto();

        //OkGoUtil.setToken(token);
        OkGoUtil.initOkGo(this, true);
        MyFrameManager.getInstance().setKeepWake(false);
        setOnFrameAppListener(new OnFrameAppListener() {
            @Override
            public void onRestart(EventRestartApp restartApp) {

            }

            @Override
            public void onClear(EventNoActivity eventNoActivity) {

            }

            @Override
            public void onHeartbeat(BeanHeartbeat heartbeat) {
            }

            @Override
            public void onMimcRouse(EventMimcRouse eventMimcRouse) {

            }
        });

//        ModuleUtil.register();

        if (isDedugARouter){
            ARouter.openLog();
            ARouter.openDebug();
        }
        ARouter.init(RvClientApplication.this);

    }


    @Override
    public void onTerminate() {
        super.onTerminate();
        ARouter.getInstance().destroy();
    }

    @Override
    public void onConfig() {
        //此方法在父类的onCreate()中调用
        SweetAlertDialog.isLargeConfirmButton = false;
        Config.appPrimary = "medical_client";
        Config.isScreenFull = false;   //不需要全屏幕展示
        Config.isBackToHome = false;    //需要屏蔽返回键，直接到手机桌面
        Config.isPrint = true;
        Config.isShowError = true;
        Config.isAutoSetTopBarColor = true;
        Config.topBarColor = R.color.colorPrimary;
        Config.isOpenHeartbeat = true;
        Config.isOpenTryCatchException = false;
        Config.heartbeatInterval = 1000;
        Config.init();
    }


    /**
     * 初始化友盟  5c99e2ce3fc195cb1e000cc2
     * https://mobile.umeng.com/platform/config/apps/create
     */
    private void initUM() {
        //设置LOG开关，默认为false
        UMConfigure.setLogEnabled(true);
        UMConfigure.init(this, "5d242bf24ca357797e000922", "umeng", UMConfigure.DEVICE_TYPE_PHONE, null);
//        PlatformConfig.setWeixin(RvFrameConfig.APP_ID, "088effbd5e5c5340779d512f87fab15e");
        PlatformConfig.setWeixin(RvFrameConfig.APP_ID, "128cf4ad74b73c16ae5c5b3601da3f27");

        PlatformConfig.setQQZone("100424468", "c7394704798a158208a74ab60104f0ba");

    }



    private void initAuto() {

        //当 App 中出现多进程, 并且您需要适配所有的进程, 就需要在 App 初始化时调用 initCompatMultiProcess()
        //在 Demo 中跳转的三方库中的 DefaultErrorActivity 就是在另外一个进程中, 所以要想适配这个 Activity 就需要调用 initCompatMultiProcess()
        AutoSize.initCompatMultiProcess(this);
        /**
         * 以下是 AndroidAutoSize 可以自定义的参数, {@link AutoSizeConfig} 的每个方法的注释都写的很详细
         * 使用前请一定记得跳进源码，查看方法的注释, 下面的注释只是简单描述!!!
         */
        AutoSizeConfig.getInstance()

                //是否让框架支持自定义 Fragment 的适配参数, 由于这个需求是比较少见的, 所以须要使用者手动开启
                //如果没有这个需求建议不开启
                .setCustomFragment(true)

                //是否屏蔽系统字体大小对 AndroidAutoSize 的影响, 如果为 true, App 内的字体的大小将不会跟随系统设置中字体大小的改变
                //如果为 false, 则会跟随系统设置中字体大小的改变, 默认为 false
//                .setExcludeFontScale(true)

                //屏幕适配监听器
                .setOnAdaptListener(new onAdaptListener() {
                    @Override
                    public void onAdaptBefore(Object target, Activity activity) {
                        //使用以下代码, 可支持 Android 的分屏或缩放模式, 但前提是在分屏或缩放模式下当用户改变您 App 的窗口大小时
                        //系统会重绘当前的页面, 经测试在某些机型, 某些情况下系统不会重绘当前页面, ScreenUtils.getScreenSize(activity) 的参数一定要不要传 Application!!!
//                        AutoSizeConfig.getInstance().setScreenWidth(ScreenUtils.getScreenSize(activity)[0]);
//                        AutoSizeConfig.getInstance().setScreenHeight(ScreenUtils.getScreenSize(activity)[1]);
                        LogUtils.d(String.format(Locale.ENGLISH, "%s onAdaptBefore!", target.getClass().getName()));
                    }

                    @Override
                    public void onAdaptAfter(Object target, Activity activity) {
                        LogUtils.d(String.format(Locale.ENGLISH, "%s onAdaptAfter!", target.getClass().getName()));
                    }
                });

        //是否打印 AutoSize 的内部日志, 默认为 true, 如果您不想 AutoSize 打印日志, 则请设置为 false
//                .setLog(false)

        //是否使用设备的实际尺寸做适配, 默认为 false, 如果设置为 false, 在以屏幕高度为基准进行适配时
        //AutoSize 会将屏幕总高度减去状态栏高度来做适配
        //设置为 true 则使用设备的实际屏幕高度, 不会减去状态栏高度
//                .setUseDeviceSize(true)

        //是否全局按照宽度进行等比例适配, 默认为 true, 如果设置为 false, AutoSize 会全局按照高度进行适配
//                .setBaseOnWidth(false)

        //设置屏幕适配逻辑策略类, 一般不用设置, 使用框架默认的就好
//                .setAutoAdaptStrategy(new AutoAdaptStrategy())

    }


}
