package com.rv.share.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.ruiwenliu.wrapper.util.ScaleUtils;

public class ProgressTab extends TextView {


    private Paint bgPaint;
    private int width;
    private int height;

    public ProgressTab(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPaint();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        width = MeasureSpec.getSize(widthMeasureSpec);
        height = MeasureSpec.getSize(heightMeasureSpec);
    }

    /********
     * 初始化画笔
     */
    private void initPaint() {
        bgPaint = new Paint();
        bgPaint.setColor(Color.parseColor("#FE6E2F"));
        bgPaint.setAntiAlias(true);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);


    }
}
