package com.rv.plugin.calendar.adapter;

import android.content.Context;
import android.graphics.Color;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.rv.component.utils.DisplayUtil;
import com.rv.plugin.calendar.bean.DateInfo;
import com.rv.plugin.calendar.R;

import java.util.List;

/**
 * 日历
 */
public class CalendarAdapter2 extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private Context context;
    private List<DateInfo> listDayInfo;
    private OnItemClickListener onItemClickListener;
    public int inPosition; //默认入住位置
    public int outPosition; //离开位置

    public CalendarAdapter2(Context context, List<DateInfo> listDayInfo) {
        this.context = context;
        this.listDayInfo = listDayInfo;
    }

    public void setOnItemClickListener( OnItemClickListener onItemClickListener){
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public int getItemViewType(int position) {
        return listDayInfo.get(position).getTypeDay();
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder vh = null;
        if (viewType == DateInfo.VIEW_TYPE_MONTH_TITLE) {
            View v = LayoutInflater.from(context).inflate(R.layout.item_calendar_header, null);
            vh = new HeaderView(v);
        } else {
            View v = LayoutInflater.from(context).inflate(R.layout.item_calendar_gridview, null);
            vh = new DayView(v);
        }
        return vh;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, final int position) {

        DateInfo dayInfo = listDayInfo.get(position);

        if (holder instanceof HeaderView) {
            HeaderView vh = (HeaderView) holder;
            vh.tvMonthTitle.setText(dayInfo.getMonth());
        } else {
            DayView vh = (DayView) holder;

            // 公历
            if (!dayInfo.getDay().equals("")) {
                vh.tvCalendarDay.setText(dayInfo.getDisplayDay());
                vh.tvCalendarDay.setTextColor(dayInfo.getDefTextColor());
                vh.tvCalendarDay.setTextSize(TypedValue.COMPLEX_UNIT_PX, dayInfo.getDefTextSize());
                vh.tvCalendarDay.setTag(dayInfo);
                // 农历
                vh.tvCalendarLunar.setText(dayInfo.getDisplayNongliDate());
                vh.tvCalendarLunar.setTextColor(dayInfo.getDefNongTextColor());
                vh.tvCalendarLunar.setTextSize(TypedValue.COMPLEX_UNIT_PX, dayInfo.getDefNongTextSize());
            }
            // 今天
            if (dayInfo.isCurDay()) {
                //holder.tvNL.setVisibility(View.GONE);
            }
            vh.llBox.setBackgroundColor(Color.WHITE);  //白色
            // 显示选中信息
            if (dayInfo.isBeginDay()) {
                selectView(vh, 1);
                inPosition=position;
            }
            if (dayInfo.isEndDay()) {
                selectView(vh, 2);
                outPosition=position;
            }

            if (dayInfo.isBeginDay() &&dayInfo.isEndDay()){
                selectView(vh, 3);
                inPosition=position;
                outPosition=position;
            }

            vh.llBox.setOnClickListener(null);
            if (dayInfo.isCanBeChoose()) {
                vh.llBox.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (onItemClickListener != null) {
                            onItemClickListener.onItemClick(v, position);
                            Log.i("calendarActivityty", "我按下去了哦");
                        }
                    }
                });
            }

            try {
                // 若日历日期<当前日期，则不能选择
                if (dayInfo.getDisplayDay().equals("") || dayInfo.getDisplayDay().length() < 1) {
                    vh.tvCalendarDay.setTextColor(Color.GRAY);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    @Override
    public int getItemCount() {
        return this.listDayInfo.size();
    }

    public interface OnItemClickListener {
        void onItemClick(View v, int position);
    }

    /**
     * 设置选中
     * @param holder
     * @param typeId 1-in,2-out
     */
    public static void selectView(DayView holder, int typeId) {
        DateInfo days = (DateInfo) holder.tvCalendarDay.getTag();
        holder.llBox.setBackgroundResource(R.drawable.shape_calender_selectbg);
        holder.tvCalendarDay.setTextColor(Color.WHITE);
        holder.tvCalendarDay.setText(days.getDisplayDay());
        holder.tvCalendarLunar.setTextColor(Color.WHITE);
        if (typeId == 1) {
            holder.tvCalendarLunar.setText("租");
            //viewIn = convertView;
            days.setBeginDay(true);
        } else if (typeId == 2){
            holder.tvCalendarLunar.setText("还");
            // viewOut = convertView;
            days.setEndDay(true);
        }else {
            holder.tvCalendarLunar.setText("租/还");
            // viewOut = convertView;
            days.setBeginDay(true);
            days.setEndDay(true);
        }
    }

    //头部
    public class HeaderView extends RecyclerView.ViewHolder {
        public TextView tvMonthTitle;

        public HeaderView(View v) {
            super(v);
            tvMonthTitle = (TextView) v.findViewById(R.id.tv_monthTitle);
        }
    }

    //日期
    public class DayView extends RecyclerView.ViewHolder {

        public TextView tvCalendarDay, tvCalendarLunar;
        public LinearLayout llBox;     //外面大的按钮背景

        public DayView(View v) {
            super(v);
            tvCalendarDay = (TextView) v.findViewById(R.id.tv_calendar_day);
            tvCalendarLunar = (TextView) v.findViewById(R.id.tv_calendar_lunar);
            llBox = (LinearLayout) v.findViewById(R.id.ll_box);
            int ww= DisplayUtil.getWidth(context);
            int wh=ww/7;
            LinearLayout.LayoutParams lp=new LinearLayout.LayoutParams(wh,wh);
            llBox.setLayoutParams(lp);
        }
    }


}
