package com.rv.plugin.calendar;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.rv.plugin.calendar.adapter.CalendarAdapter2;
import com.rv.plugin.calendar.bean.DateInfo;

import java.util.Calendar;
import java.util.List;

/**
 * 日历
 */
public class CalendarView2 extends FrameLayout {

    private RecyclerView rvListview;
    private Context mContext;
    private List<DateInfo> listDayInfo;
    public int selectInPosition; //选中的入住日期
    public int selectOutPosition;
    public int commmon;  //中间变量
    private OnDayClickListener mDayClickListener;
    private LinearLayout llTopMonth, llNextMonth;
    private GridLayoutManager gridLayoutManager;
    private TextView tvTopMonthTitle, tvNextMonthTitle;

    public CalendarView2(Context context) {
        super(context);
    }

    public CalendarView2(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        View view = LayoutInflater.from(mContext).inflate(R.layout.v_calendarview, null);
        rvListview = (RecyclerView) view.findViewById(R.id.rv_listview);
        LinearLayout llTitleBox = (LinearLayout) view.findViewById(R.id.ll_title_Box);
//        llTopMonth = (LinearLayout) LayoutInflater.from(mContext).inflate(R.layout.item_calendar_header, null);
//        llNextMonth = (LinearLayout) LayoutInflater.from(mContext).inflate(R.layout.item_calendar_header, null);
//        tvTopMonthTitle = (TextView) llTopMonth.findViewById(R.id.tv_monthTitle);
//        tvNextMonthTitle = (TextView) llNextMonth.findViewById(R.id.tv_monthTitle);
//        llTitleBox.setAlpha(0.8f);
//        llTitleBox.addView(llTopMonth);
//        llTitleBox.addView(llNextMonth);
        llTitleBox.setVisibility(GONE);
        this.addView(view);
    }

    /**
     * 设置日历
     *
     * @param listDay
     */
    public void setData(List<DateInfo> listDay) {

        if (listDay == null || listDay.size() == 0) {
            return;
        }
        this.listDayInfo = listDay;

        final CalendarAdapter2 adapter = new CalendarAdapter2(mContext, listDayInfo);
        adapter.setOnItemClickListener(new CalendarAdapter2.OnItemClickListener() {
            @Override
            public void onItemClick(View v, int position) {
                if (listDayInfo.get(position).isCanBeChoose()) {
                    DateInfo dateInfo = listDayInfo.get(position);
                    if (selectInPosition == 0 && adapter.inPosition != 0) {
                        listDayInfo.get(adapter.inPosition).setBeginDay(false);
                    }

                    if (selectOutPosition == 0 && adapter.outPosition != 0) {
                        listDayInfo.get(adapter.outPosition).setEndDay(false);
                    }

                    if (selectInPosition !=0 &&selectOutPosition !=0 && adapter.inPosition != 0 &&adapter.outPosition != 0){
                        listDayInfo.get(adapter.inPosition).setBeginDay(false);
                        listDayInfo.get(adapter.outPosition).setEndDay(false);
                        selectInPosition = 0;
                        selectOutPosition = 0;
                    }

                    if (selectInPosition == 0) {
                        selectInPosition = position;
                        adapter.inPosition = position;
                        dateInfo.setBeginDay(true);
                        adapter.notifyDataSetChanged();
                        mDayClickListener.inClick(dateInfo);
                    } else {
                        if (position < selectInPosition) {
                            listDayInfo.get(selectInPosition).setBeginDay(false);
                            commmon =selectInPosition;

                            selectInPosition = position;
                            adapter.inPosition = position;
                            dateInfo.setBeginDay(true);
                            adapter.notifyDataSetChanged();
                            mDayClickListener.inClick(dateInfo);

                            selectOutPosition = commmon;
                            adapter.outPosition = commmon;
                            listDayInfo.get(commmon).setEndDay(true);
                            mDayClickListener.outClick(listDayInfo.get(commmon));
                        } else {
                            selectOutPosition = position;
                            adapter.outPosition = position;
                            dateInfo.setEndDay(true);
                            adapter.notifyDataSetChanged();
                            mDayClickListener.outClick(dateInfo);
                        }
                    }
                }
            }
        });


        gridLayoutManager = new GridLayoutManager(mContext, 7);
        gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                if (listDayInfo.get(position).getTypeDay() == DateInfo.VIEW_TYPE_MONTH_TITLE) {
                    return 7;
                } else {
                    return 1;
                }
            }
        });


        rvListview.setLayoutManager(gridLayoutManager);
        rvListview.setAdapter(adapter);

        //rvListview.addOnScrollListener(new ScrollListenerAnim());
        gridLayoutManager.scrollToPosition(0);

    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        mDayClickListener = listener;
    }

    /**
     * 点击当前日期
     */
    public interface OnDayClickListener {
        //入住时间
        void inClick(DateInfo date);

        //离店时间
        void outClick(DateInfo date);
    }

    private boolean mIsFirst = true;
    private float mTopMonthViewPosition1;
    private float mTopMonthViewPosition2;
    private float mTopMonthViewPosition3;

    /**
     * 在此实现了顶部标题动画切换效果
     */
    public class ScrollListenerAnim extends RecyclerView.OnScrollListener {


        //上一次可见位置
        private int lastFirstVisiblePosition = -1;

        /*
         * 上一次滑动方向
         * 0上滑
         * 1下滑
         */
        private int lastScrollDirection = 1;

        @Override
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {

            int curVisiblePosition = gridLayoutManager.findFirstVisibleItemPosition();

            // 第一行非月份标题不进行动画
            if (listDayInfo.get(curVisiblePosition).getTypeDay() != DateInfo.VIEW_TYPE_MONTH_TITLE) {
                return;
            }

            // 滑动方向未变并且第一可见行未变不进行动画
            if (dy < 0 && lastScrollDirection == 0 && lastFirstVisiblePosition == curVisiblePosition) {
                return;
            } else if (dy > 0 && lastScrollDirection == 1 && lastFirstVisiblePosition == curVisiblePosition) {
                return;
            }
            String topMonth = listDayInfo.get(curVisiblePosition).getMonth();
            String nextMoth = CalendarDateUtil.addDate2(topMonth, Calendar.MONTH, 1);

            if (dy < 0) {
                lastScrollDirection = 0;
                topMonth = CalendarDateUtil.addDate2(topMonth, Calendar.MONTH, -1);
            } else if (dy > 0) {
                lastScrollDirection = 1;
            }
            lastFirstVisiblePosition = curVisiblePosition;

            tvTopMonthTitle.setText(topMonth);
            tvNextMonthTitle.setText(nextMoth);

            if (dy < 0) {
                // 上滑
                startTopMonthAnim(true);
            } else if (dy > 0) {
                // 下滑
                startTopMonthAnim(false);
            }
        }

        @Override
        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
        }
    }

    /**
     * 顶部标题动画切换效果
     *
     * @param isUP
     */
    private void startTopMonthAnim(boolean isUP) {
        long duration = 200;

        if (mIsFirst) {
            mTopMonthViewPosition2 = llTopMonth.getY(); //0
            mTopMonthViewPosition3 = llNextMonth.getY(); //180
            mTopMonthViewPosition1 = mTopMonthViewPosition2 - (mTopMonthViewPosition3 - mTopMonthViewPosition2); //-180
            mIsFirst = false;
        }

        // 上滑
        if (isUP) {
            ObjectAnimator anim1 = ObjectAnimator.ofFloat(llTopMonth, "y", mTopMonthViewPosition1, mTopMonthViewPosition2).setDuration(duration);
            anim1.setInterpolator(new AccelerateDecelerateInterpolator());
            anim1.start();

            ObjectAnimator anim2 = ObjectAnimator.ofFloat(llNextMonth, "y", mTopMonthViewPosition2, mTopMonthViewPosition3).setDuration(duration);
            anim2.setInterpolator(new AccelerateDecelerateInterpolator());
            anim2.start();
        }

        // 下滑
        else {
            ObjectAnimator anim1 = ObjectAnimator.ofFloat(llTopMonth, "y", mTopMonthViewPosition2, mTopMonthViewPosition1).setDuration(duration);
            anim1.setInterpolator(new AccelerateDecelerateInterpolator());
            anim1.start();

            ObjectAnimator anim2 = ObjectAnimator.ofFloat(llNextMonth, "y", mTopMonthViewPosition3, mTopMonthViewPosition2).setDuration(duration);
            anim2.setInterpolator(new AccelerateDecelerateInterpolator());
            anim2.start();
        }
    }

}
