package com.rv.home.rv.module.ui.main.home.order.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.entity.MultiItemEntity;
import com.ruiwenliu.wrapper.util.BaseGlideHolder;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.DateUtils;
import com.rv.home.R;
import com.rv.home.rv.module.ui.main.home.order.bean.OrderListBean;
import com.rv.home.rv.module.ui.main.home.order.view.MyTimerView;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/30.
 * Desc:待付款
 */

public class ForPaymentAdapter extends BaseMultiItemQuickAdapter<MultiItemEntity, BaseGlideHolder> {

    public static final int TYPE_FOR_PAYMENT = 1;   //1--租车；2--旅游
    public static final int TYPE_TO_TRAVEL = 2;
    public static final int TYPE_TO_MEMBER = 3;

    public ForPaymentAdapter(List<MultiItemEntity> data) {
        super(data);
        addItemType(TYPE_FOR_PAYMENT, R.layout.rv_item_order_for_payment);
        addItemType(TYPE_TO_TRAVEL, R.layout.rv_item_order_to_travel);
        addItemType(TYPE_TO_MEMBER, R.layout.rv_item_order_to_member);
    }

    @Override
    protected void convert(BaseGlideHolder helper, MultiItemEntity item) {

        OrderListBean.DataBeanX.DataBean dataBean;
        switch (helper.getItemViewType()) {
            case TYPE_FOR_PAYMENT:
                dataBean = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean == null) {
                    return;
                }
                setTimes(Cookie.getLongValue(mContext, "actRent"), helper, (OrderListBean.DataBeanX.DataBean) item);
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean.getCrtTime()));
                if (dataBean.getOrderRentVehicleDetail() != null && dataBean.getOrderRentVehicleDetail().getStart_city_name() != null) {
                    helper.setText(R.id.tv_city, dataBean.getOrderRentVehicleDetail().getStart_city_name());
                }

                helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                helper.loadRoundImage(mContext, dataBean.getIcon(), (ImageView) helper.getView(R.id.iv_goods), 8);
                helper.setText(R.id.tv_car_type, dataBean.getName());
                if (dataBean.getOrderRentVehicleDetail() != null) {
                    helper.setText(R.id.tv_get_time, DateUtils.timestampToString1(dataBean.getOrderRentVehicleDetail().getStart_time()));
                    helper.setText(R.id.tv_get_address, dataBean.getOrderRentVehicleDetail().getStart_addr());
                    helper.setText(R.id.tv_out_time,  DateUtils.timestampToString1(dataBean.getOrderRentVehicleDetail().getEnd_time()));
                    helper.setText(R.id.tv_out_address, dataBean.getOrderRentVehicleDetail().getEnd_addr());
                    helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean.getRealAmount()));
                }
                helper.setText(R.id.tv_process, mContext.getString(R.string.rv_to_pay_for));
                helper.addOnClickListener(R.id.tv_process);
                break;
            case TYPE_TO_TRAVEL:
                dataBean = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean == null) {
                    return;
                }
                if (dataBean.getOrderTourDetail() == null) {
                    return;
                }
                setTimes(Cookie.getLongValue(mContext, "actTour"), helper, (OrderListBean.DataBeanX.DataBean) item);
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean.getCrtTime()));
                helper.setText(R.id.tv_city, dataBean.getOrderTourDetail().getStartCityName());
                helper.loadRoundImage(mContext, dataBean.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 8);
                helper.setText(R.id.tv_car_type, dataBean.getName());
                helper.setText(R.id.tv_out_time, mContext.getString(R.string.rv_to_time) +  DateUtils.timestampToString1(dataBean.getOrderTourDetail().getStartTime()));
                helper.setText(R.id.tv_count_person, String.format("%1$s%2$s", mContext.getString(R.string.rv_to_person), dataBean.getOrderTourDetail().getTotalNumber(), mContext.getString(R.string.rv_person)));
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean.getRealAmount()));
                helper.setText(R.id.tv_camp_process, mContext.getString(R.string.rv_to_pay_for));
                helper.addOnClickListener(R.id.tv_camp_process);
                break;
            case TYPE_TO_MEMBER:
                dataBean = (OrderListBean.DataBeanX.DataBean) item;
                if (dataBean == null) {
                    return;
                }
                if (dataBean.getOrderMemberDetail() == null) {
                    return;
                }
                setTimes(Cookie.getLongValue(mContext, "actMember"), helper, (OrderListBean.DataBeanX.DataBean) item);
                helper.setText(R.id.tv_order_time, String.format("%1$s%2$s", mContext.getString(R.string.rv_order_time), dataBean.getCrtTime()));
                helper.loadRoundImage(mContext, dataBean.getPicture(), (ImageView) helper.getView(R.id.iv_goods), 8);
                helper.setText(R.id.tv_name, dataBean.getName());
                helper.setText(R.id.tv_content, dataBean.getOrderMemberDetail().getContent());
                helper.setText(R.id.tv_price, String.format("¥%1$s", dataBean.getRealAmount()));
                helper.setText(R.id.tv_member_pay, mContext.getString(R.string.rv_to_pay_for));
                helper.addOnClickListener(R.id.tv_member_pay);
                helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                break;
        }
    }

    private void setTimes(long effTime, BaseGlideHolder helper, OrderListBean.DataBeanX.DataBean bean) {
        if (bean != null) {
            String crtStr = bean.getCrtTime();
            if (!TextUtils.isEmpty(crtStr)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date = format.parse(crtStr);
                    long remain = effTime - (System.currentTimeMillis() - date.getTime());
                    if (remain <= 0) {
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.tv_order_cancel));
                        switch (bean.getType()) {
                            case TYPE_FOR_PAYMENT:
                                helper.itemView.findViewById(R.id.tv_process).setVisibility(View.GONE);
                                break;
                            case TYPE_TO_TRAVEL:
                                helper.itemView.findViewById(R.id.tv_camp_process).setVisibility(View.GONE);
                                break;
                            case TYPE_TO_MEMBER:
                                helper.itemView.findViewById(R.id.tv_member_pay).setVisibility(View.GONE);
                                break;
                        }
                    } else {
                        helper.setText(R.id.tv_order_state, mContext.getString(R.string.rv_order_for_payment));
                        ((MyTimerView) helper.itemView.findViewById(R.id.tv_remain_time)).setTime(effTime, date.getTime(), timerListener);
                    }
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void addNewData(OrderListBean bean) {
        mData.clear();
        addData(bean.getData().getData());
        notifyDataSetChanged();
    }

    public MyTimerView.TimerListener timerListener = new MyTimerView.TimerListener() {
        @Override
        public void onTimeFinish() {
            notifyDataSetChanged();
        }
    };
}
