package com.rv.home.rv.module.ui.main.home.adapter;

import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.rv.home.R;
import com.rv.home.rv.module.basic.bean.MultiItemBean;
import com.rv.home.rv.module.ui.main.home.bean.CityHeadBean;
import com.rv.home.rv.module.ui.main.home.bean.HotCityBean;
import com.rv.home.rv.module.ui.main.home.bean.HotCityListBean;
import com.rv.home.rv.module.ui.main.home.bean.ListsBean;

import java.util.List;

/**
 * Created :Auser
 * Date: 2019/5/11.
 * Desc:城市列表Adapter
 */

public class CityListAdapter extends BaseMultiItemQuickAdapter<MultiItemBean, BaseViewHolder> {
    public static final int TYPE_INDEX_HEAD = 1;
    public static final int TYPE_INDEX_HOT = 2;
    public static final int TYPE_INDEX_CITY = 3;

    private GridClickListener mListener;
    private String currentCity;
    private TextView tvCurrent;

    public CityListAdapter(List<MultiItemBean> data, GridClickListener listener, String currentCity) {
        super(data);
        this.mListener = listener;
        this.currentCity = currentCity;
        addItemType(TYPE_INDEX_HEAD, R.layout.rv_item_head);
        addItemType(TYPE_INDEX_HOT, R.layout.rv_list_hot_city);
        addItemType(TYPE_INDEX_CITY, R.layout.rv_item_city);
    }

    public void setCurrentCity(String currentCity) {
        this.currentCity = currentCity;
        if (tvCurrent != null)
            tvCurrent.setText(TextUtils.isEmpty(this.currentCity) ? "定位失败" : "当前定位城市: " + this.currentCity);
    }

    @Override
    protected void convert(BaseViewHolder helper, MultiItemBean item) {
        switch (helper.getItemViewType()) {
            case TYPE_INDEX_HEAD:
                CityHeadBean cityHeadBean = (CityHeadBean) item;
                helper.setText(R.id.tv_head, cityHeadBean.headName);
                break;
            case TYPE_INDEX_HOT:
                HotCityListBean hotCityListBean = (HotCityListBean) item;
                tvCurrent = helper.itemView.findViewById(R.id.tv_current_city);
                tvCurrent.setText(TextUtils.isEmpty(currentCity) ? "定位失败" : "当前定位城市: " + currentCity);
                TextView tvRelocation = helper.itemView.findViewById(R.id.tv_relocation);
                tvRelocation.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mListener != null) {
                            mListener.reRelocation();
                        }
                    }
                });
                final HotCityAdapter hotCityAdapter = new HotCityAdapter(mContext, hotCityListBean.getLists());
                final GridView gridView = helper.itemView.findViewById(R.id.gdv_hot_city);
                gridView.setAdapter(hotCityAdapter);
                gridView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                        if (mListener != null) {
                            mListener.click((HotCityBean) hotCityAdapter.getItem(position));
                        }
                    }
                });
                break;
            case TYPE_INDEX_CITY:
                ListsBean cityBean = (ListsBean) item;
                helper.setText(R.id.tv_city, cityBean.getName());
                break;
        }
    }

    public int getSelectIndex(String an) {
        if (an.equals("定位") || an.equals("热门")) {
            return 0;
        }

        if (TextUtils.isEmpty(an)) {
            return -1;
        }
        for (MultiItemBean bean : getData()) {
            if (bean.getItemType() == TYPE_INDEX_HEAD) {
                CityHeadBean headBean = (CityHeadBean) bean;
                if (headBean.headName.equals(an)) {
                    return getData().indexOf(bean);
                }
            }
        }

        return -1;
    }

    public interface GridClickListener {

        /****
         * 选择城市
         * @param hotCityBean
         */
        void click(HotCityBean hotCityBean);

        /******
         * 重新定位
         */
        void reRelocation();
    }
}
