package com.xxfc.discovery.adapter;

import android.widget.ImageView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.xxfc.discovery.R;
import com.xxfc.discovery.bean.DiscoveryRecommendBean;

/**
 * 推荐
 */

public class DiscoveryRecommendAdapter extends BaseQuickAdapter<DiscoveryRecommendBean.DataBeanX.DataBean, BaseViewHolder> {

    public DiscoveryRecommendAdapter() {
        super(R.layout.rv_item_discovery_recommend);
    }

    @Override
    protected void convert(BaseViewHolder helper, DiscoveryRecommendBean.DataBeanX.DataBean item) {
        if (item == null) {
            return;
        }
        DiscoveryRecommendBean.DataBeanX.DataBean.Body body = item.getBody();
        if (body != null) {
            if (body.getImages() != null && body.getImages().size() > 0) {
                GlideManager.getInstance(mContext).loadRoundImage2(body.getImages().get(0).getOurl(), (ImageView) helper.getView(R.id.iv_icon),8);
            }
            helper.setText(R.id.tv_title, body.getText());
            if ("4".equals(body.getType())) { //消息类型 基础属性 1=文字消息、2=图文消息、3=语音消息、4=视频消息、 5=文件消
                helper.setGone(R.id.iv_isvideo, true);
            } else {
                helper.setGone(R.id.iv_isvideo, false);
            }
        }
        helper.setText(R.id.tv_user_name, item.getNickname());
        GlideManager.getInstance(mContext).loadImage(item.getPicUrl(), (ImageView) helper.getView(R.id.iv_user_icon));
        if (item.getCount() != null) {
            helper.setText(R.id.iv_like_number, item.getCount().getPraise());
        }
        if ("1".equals(item.getIsPraise())) { //0：未点赞 1：已点赞
            helper.setImageResource(R.id.iv_like, R.drawable.icon_discovery_ask_like);
        } else {
            helper.setImageResource(R.id.iv_like, R.drawable.icon_discovery_ask_unlike);
        }

        helper.addOnClickListener(R.id.ll_item_islike);
    }
}
