package com.base.utils.ui.refresh.circle.simple;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.base.utils.R;
import com.base.utils.base.BaseActivity;
import com.base.utils.ui.refresh.LoadMoreUtil;
import com.base.utils.ui.refresh.circle.CircleRefreshLayout;

/**
 * 上拉弹出圆形刷新演示
 */

public class SampleCircleRefreshActivity extends BaseActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.sample_activity_cricle_refresh);
        onData();
        onView();
    }

    CircleRefreshLayout refreshLayout;

    @Override
    public void onData() {
        refreshLayout = (CircleRefreshLayout) findViewById(R.id.circle_refresh);
        RecyclerView recyclerView = (RecyclerView) findViewById(R.id.circle_recycler);
        recyclerView.setLayoutManager(new LinearLayoutManager(baseContext));
        recyclerView.setAdapter(new CircleRefreshAdapter());

        LoadMoreUtil.setLoadMoreListener(recyclerView);
    }

    @Override
    public void onView() {
        refreshLayout.setOnRefreshListener(new CircleRefreshLayout.OnCircleRefreshListener() {
            @Override
            public void completeRefresh() {

            }

            @Override
            public void refreshing() {

            }
        });
        findViewById(R.id.circle_end).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                refreshLayout.finishRefreshing();
            }
        });
    }

    class CircleRefreshAdapter extends RecyclerView.Adapter<CircleRefreshAdapter.CircleRefreshViewHolder> {

        @Override
        public CircleRefreshViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from(baseContext).inflate(R.layout.sample_item_cricle_refresh, parent, false);
            return new CircleRefreshViewHolder(v);
        }

        @Override
        public void onBindViewHolder(CircleRefreshViewHolder holder, int position) {

        }

        @Override
        public int getItemCount() {
            return 20;
        }

        class CircleRefreshViewHolder extends RecyclerView.ViewHolder {

            public CircleRefreshViewHolder(View itemView) {
                super(itemView);
            }
        }
    }
}
