package com.xxrv.coupon;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.adapter.TabAdapter;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseFragment;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.horizontal.GallerySnapHelper;
import com.ruiwenliu.wrapper.weight.horizontal.SpaceItemDecoration;
import com.xxrv.coupon.adapter.CouponMenuAdapter;
import com.xxrv.coupon.fragment.ExpiredCouponFragment;
import com.xxrv.coupon.fragment.UsedCouponFragment;
import com.xxrv.coupon.fragment.WaitCouponFragment;
import com.xxrv.coupon.presenter.CouponAllPresenter;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

@Route(path = Constance.ACTIVITY_URL_COUPONALL)
public class CouponAllActivity extends BaseStatusActivity<CouponAllPresenter> {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.order_viewPager)
    ViewPager mViewPager;

    private CouponMenuAdapter menuAdapter;
    private TabAdapter mAdapter;
    public final static int TYPE_TO_BE_USED = 0;//待使用
    public final static int TYPE_Used = 1;//已使用
    public final static int TYPE_EXPIRED = 2;//已过期
    private int menuPosition;

    @Override
    protected int setLayout() {
        return R.layout.activity_coupon_all;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        menuPosition = intent.getIntExtra("position", 0);
        titleView.setTitle("优惠券");
        initRecyclerView();
        initViewpager();
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    /**
     * 初始化RecyclerView
     */
    private void initRecyclerView() {
        recyclerView.setLayoutManager(new GridLayoutManager(mActivity, 3));
        menuAdapter = new CouponMenuAdapter();
        recyclerView.setAdapter(menuAdapter);
        recyclerView.addItemDecoration(new SpaceItemDecoration(5));
        GallerySnapHelper snapHelper = new GallerySnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        List<String> list = new ArrayList<>();
        list.add("待使用");
        list.add("已使用");
        list.add("已过期");
        menuAdapter.setNewData(list);
        menuAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        });
    }

    /**
     * 初始化Viewpager
     */
    private void initViewpager() {
        mAdapter = new TabAdapter(getSupportFragmentManager(), getListFragment());
        mViewPager.setAdapter(mAdapter);
        mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                menuAdapter.setSelectItem(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });
        mViewPager.setOffscreenPageLimit(mAdapter.getCount());
        menuAdapter.setSelectItem(menuPosition);
        mViewPager.setCurrentItem(menuPosition);
    }


    private List<BaseFragment> getListFragment() {
        List<BaseFragment> list = new ArrayList<>();
        list.add(WaitCouponFragment.getInstance(TYPE_TO_BE_USED));
        list.add(UsedCouponFragment.getInstance(TYPE_Used));
        list.add(ExpiredCouponFragment.getInstance(TYPE_EXPIRED));
        return list;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mAdapter.getCurrentFragment().onActivityResult(requestCode, resultCode, data);
    }

    public SwitchListener switchListener = new SwitchListener() {
        @Override
        public void switchTab(int position) {
            if (menuAdapter != null && mViewPager != null) {
                menuAdapter.setSelectItem(position);
                mViewPager.setCurrentItem(position);
            }
        }
    };

    /******
     * 切换事件
     */
    public interface SwitchListener {
        void switchTab(int position);
    }
}
