package com.xxrv.carpurchase.beam;

import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.ruiwenliu.wrapper.base.BaseBean;

import java.io.Serializable;
import java.util.List;

/**
 * 购房车列表
 */

public class CarPurChaseListBean extends BaseBean implements Serializable {


    private DataBeanX data;
    private boolean rel;

    public DataBeanX getData() {
        return data;
    }

    public void setData(DataBeanX data) {
        this.data = data;
    }

    public boolean isRel() {
        return rel;
    }

    public void setRel(boolean rel) {
        this.rel = rel;
    }

    public static class DataBeanX implements Serializable {

        private int totalCount;
        private int totalPage;
        private int pageNum;
        private int pageSize;
        private List<DataBean> data;

        public int getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getTotalPage() {
            return totalPage;
        }

        public void setTotalPage(int totalPage) {
            this.totalPage = totalPage;
        }

        public int getPageNum() {
            return pageNum;
        }

        public void setPageNum(int pageNum) {
            this.pageNum = pageNum;
        }

        public int getPageSize() {
            return pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public List<DataBean> getData() {
            return data;
        }

        public void setData(List<DataBean> data) {
            this.data = data;
        }

        public static class DataBean implements Serializable {
            private String id;         //  车型id
            private String name;        //车型名
            private String config;      //房车配置
            private String number;      //乘卧数量
            private String brand;         //品牌
            private String keyword;        //关键标签，code逗号分割
            private String modelsDetails;   //车型详情
            private String modelParam;      //房车参数
            private String picture;         //图片地址 多张为逗号分割
            private double price;            //租车价格
            private double deposit;          //总押金
            private double vioDeposit;        //违章押金
            private int score;             //评分
            private String hotSign;           //热度标记，1--热门；2--非热门
            private String rentDiscountStatus;  //租车优惠状态 0--没有优惠;1--会员折扣;2--固定值
            private String rentDiscountPrice;   //租车优惠价格，根据会员等级逗号分割
            private double buyPrice;             //购买价格
            private String sum;                 //总数量
            private String leasableQuantity;    //可租借数量
            private String coverPic;

            public String getId() {
                return id;
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getName() {
                return name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getConfig() {
                return config;
            }

            public void setConfig(String config) {
                this.config = config;
            }

            public String getNumber() {
                return number;
            }

            public void setNumber(String number) {
                this.number = number;
            }

            public String getBrand() {
                return brand;
            }

            public void setBrand(String brand) {
                this.brand = brand;
            }

            public String getKeyword() {
                return keyword;
            }

            public void setKeyword(String keyword) {
                this.keyword = keyword;
            }

            public String getModelsDetails() {
                return modelsDetails;
            }

            public void setModelsDetails(String modelsDetails) {
                this.modelsDetails = modelsDetails;
            }

            public String getModelParam() {
                return modelParam;
            }

            public void setModelParam(String modelParam) {
                this.modelParam = modelParam;
            }

            public String getPicture() {
                return picture;
            }

            public void setPicture(String picture) {
                this.picture = picture;
            }

            public String getIcon() {
                String icon = "";
                if (!TextUtil.isEmpty(picture)) {
                    String[] icons = picture.split(",");
                    if (icons != null && icons.length > 0) {
                        icon = icons[0];
                    } else {
                        icon = picture;
                    }
                }

                return icon;
            }

            public double getPrice() {
                return price;
            }

            public void setPrice(double price) {
                this.price = price;
            }

            public double getDeposit() {
                return deposit;
            }

            public void setDeposit(double deposit) {
                this.deposit = deposit;
            }

            public double getVioDeposit() {
                return vioDeposit;
            }

            public void setVioDeposit(double vioDeposit) {
                this.vioDeposit = vioDeposit;
            }

            public int getScore() {
                return score;
            }

            public void setScore(int score) {
                this.score = score;
            }

            public String getHotSign() {
                return hotSign;
            }

            public void setHotSign(String hotSign) {
                this.hotSign = hotSign;
            }

            public String getRentDiscountStatus() {
                return rentDiscountStatus;
            }

            public void setRentDiscountStatus(String rentDiscountStatus) {
                this.rentDiscountStatus = rentDiscountStatus;
            }

            public String getRentDiscountPrice() {
                return rentDiscountPrice;
            }

            public void setRentDiscountPrice(String rentDiscountPrice) {
                this.rentDiscountPrice = rentDiscountPrice;
            }

            public double getBuyPrice() {
                return buyPrice;
            }

            public void setBuyPrice(double buyPrice) {
                this.buyPrice = buyPrice;
            }

            public String getSum() {
                return sum;
            }

            public void setSum(String sum) {
                this.sum = sum;
            }

            public String getLeasableQuantity() {
                return leasableQuantity;
            }

            public void setLeasableQuantity(String leasableQuantity) {
                this.leasableQuantity = leasableQuantity;
            }

            public String getCoverPic() {
                return coverPic;
            }

            public void setCoverPic(String coverPic) {
                this.coverPic = coverPic;
            }
        }
    }
}
