package com.rv.tourism.other;


import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.fastjson.JSON;
import com.baidu.mapapi.model.LatLng;
import com.base.utils.ui.datetime.selector.util.TextUtil;
import com.frame.base.bus.IDCardCertificationEvent;
import com.frame.base.bus.Observer;
import com.frame.base.bus.RxBus;
import com.frame.base.url.Constance;
import com.frame.rv.config.CommonApi;
import com.frame.rv.config.RvFrameConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.bean.BeanUserInfo;
import com.ruiwenliu.wrapper.util.MapUtil;
import com.ruiwenliu.wrapper.util.ViewHolder;
import com.ruiwenliu.wrapper.util.um.CustomShareListener;
import com.ruiwenliu.wrapper.util.um.ShareManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.dialog.BottomPromptDialog;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.IsAppInstall;
import com.rv.component.utils.LocationRecord;
import com.rv.tourism.R;
import com.rv.tourism.R2;
import com.rv.tourism.api.TourismApi;
import com.rv.tourism.bean.BeanOrderParam;
import com.rv.tourism.bean.BeanTourDetail;
import com.rv.tourism.bean.BeanTourDetailData;
import com.rv.tourism.bean.BeanTourismCollection;
import com.rv.tourism.dialog.TravelBookingDialog;
import com.rv.tourism.presenter.TourismPresenter;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.utils.ShareBoardlistener;
import com.yuyife.okgo.OkGoUtil;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;
import io.reactivex.schedulers.Schedulers;

import static com.ruiwenliu.wrapper.weight.webview.SafeWebView.hasKitkat;

/**
 * 旅游详情
 */
@Route(path = Constance.ACTIVITY_URL_TRAVELDETAILS)
public class TravelDetailsActivity extends BaseStatusActivity<TourismPresenter> {
    @BindView(R2.id.pb_progress)
    ProgressBar pbProgress;
    @BindView(R2.id.webView)
    WebView mWebView;
    @BindView(R2.id.tv_center)
    TextView tvTitleCenter;
    @BindView(R2.id.iv_collect)
    ImageView ivCollect;
    @BindView(R2.id.iv_share)
    ImageView ivShare;
    @BindView(R2.id.ll_item_bottom)
    LinearLayout llItemBottom;
    @BindView(R2.id.tv_appointment)
    TextView TvAppointment;


    private ShareManager shareManager;
    private String webUrl;
    private BeanOrderParam beanOrderParam;
    private String mCollectId;
    private static String isCollection = "0";  //0 没有收藏  1 收藏
    private ClipboardManager myClipboard;
    private TravelBookingDialog travelBookingDialog;
    private BeanTourDetailData.DataBeanX DetailsData;


    @Autowired()
    String id;

    @Autowired()
    String name;

    @Autowired()
    String content;

    @Autowired()
    String url;

    @Autowired()
    String posterBackground;

    @Autowired()
    double price;

    private String code;

//    public static Intent getIntent(Context context, BeanTourAround.DataBeanX.DataBean dataBean) {
//        return new Intent(context, TravelDetailsActivity.class)
//                .putExtra("dataBean", dataBean);
//    }


    @Override
    protected int setLayout() {
        return R.layout.activity_travel_details;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
        tvTitleCenter.setText("旅游详情");
        webUrl = TourismApi.TRAVEL_DETAILS + "?id=" + id + "?v=1";
        initWeb();
        initRxbus();
        if (!TextUtils.isEmpty(name) && !TextUtils.isEmpty(url)) {
            code = Cookie.getStringValue(getApplicationContext(), SPConstance.USER_JSON_CODE, "");
            initShare(webUrl + "&shareType=app&code=" + code, name, " ", url);
        }

        mWebView.loadUrl("JavaScript:getTourStock()"); // Android调用h5
    }

    private void initRxbus() {
        RxBus.tObservable(IDCardCertificationEvent.class)
                .observeOn(Schedulers.newThread())
                .subscribe(new Observer<IDCardCertificationEvent>(disposable) {
                    @Override
                    public void onNext(IDCardCertificationEvent event) {
                        mWebView.loadUrl("JavaScript:openModal()"); // Android调用h5
                        llItemBottom.setVisibility(View.GONE);
                    }
                });
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            mWebView.setOnScrollChangeListener(new View.OnScrollChangeListener() {
                @Override
                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {

                    Log.d("scroll", "scrollX=" + scrollX);
                    Log.d("scroll", "scrollY=" + scrollY);
                    Log.d("scroll", "oldScrollX=" + oldScrollX);
                    Log.d("scroll", "oldScrollY=" + oldScrollY);
                }
            });
        }
    }

    @OnClick({R2.id.iv_back, R2.id.tv_appointment, R2.id.iv_collect, R2.id.iv_share, R2.id.tv_customer_service})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.iv_collect) {
            //收藏
            if ("1".equals(isCollection)) {
                cancelCollect();
                ivCollect.setImageResource(R.drawable.travel_rv_collect);
            } else {
                addCollect();
                ivCollect.setImageResource(R.drawable.common_icon_collected);
            }
            ivCollect.setEnabled(false);

        } else if (id == R.id.iv_share) {
            //分享
            if (shareManager != null) {
                shareManager.open();
            }

        } else if (id == R.id.tv_customer_service) {
            //联系客服
            Intent intent = new Intent(Intent.ACTION_DIAL);
            Uri uri = Uri.parse("tel:" + "4000369369");
            intent.setData(uri);
            startActivity(intent);

        } else if (id == R.id.tv_appointment) {
            //预订

            //实名认证
//            BeanUserInfo.UserInfo userInfo = getUserInfo();
//            if (userInfo !=null){
//                if (userInfo.getCertificationStatus() ==0){
//                    ARouter.getInstance().build(Constance.ACTIVITY_URL_IDCARDCERTIFICATION).navigation();
//                    return;
//                }
//            }


//            mWebView.loadUrl("JavaScript:openModal()"); // Android调用h5

            travelBooking();
        }
    }

    /**
     * 预定
     */
    private void travelBooking() {
        if (TextUtils.isEmpty(OkGoUtil.getToken())) {
            ARouter.getInstance().build(Constance.ACTIVITY_URL_LOGINRV).navigation();
            return;
        }

        if (DetailsData != null) {
            if (travelBookingDialog == null) {
                travelBookingDialog = new TravelBookingDialog(mActivity);
            }
            travelBookingDialog.setNewData(DetailsData);
            travelBookingDialog.show();
        }

        travelBookingDialog.setOnDayClickListener(new TravelBookingDialog.OnOKClickListener() {
            @Override
            public void onClickData(BeanOrderParam data) {
                startActivity(TravelerConfirmOrderActivity.getIntent(mActivity, data));
            }
        });
    }

    private void cancelCollect() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            mPresenter.postBodyData(RvFrameConfig.HOST, 2, TourismApi.COMMIT_COLLECT_REMOVE, BaseBean.class, new CancelCollection(mCollectId, "1"), headMap, true);
        }
    }

    private void addCollect() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            mPresenter.postBodyData(RvFrameConfig.HOST, 1, TourismApi.COMMIT_COLLECT_ADD, BaseBean.class, new AddCollection(id, "2"), headMap, true);
        }
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        requestCollect();
        if (TextUtils.isEmpty(name) || TextUtils.isEmpty(url)) {
            getTourDetail();
        }
        getDetailData();
    }

    /**
     * 详情页面数据请求
     */
    private void getDetailData() {
        Map<String, Object> map = new HashMap<>();
        map.put("goodId", id);
        mPresenter.getData(RvFrameConfig.HOST, 4, TourismApi.TOUR_UNAUTH_DETAILS, BeanTourDetailData.class, map, false);
    }

    //收藏请求
    private void requestCollect() {
        Map<String, Object> headMap = new LinkedHashMap<>();
        Map<String, String> map = new HashMap<>();
        if (OkGoUtil.getToken() != null) {
            headMap.put("Authorization", OkGoUtil.getToken());
            map.put("id", id);
            map.put("type", "2");
            mPresenter.getData(RvFrameConfig.HOST, 0, TourismApi.COMMIT_COLLECT_IS, BeanTourismCollection.class, map, headMap, false);
        }
    }


    @Override
    public void onShowResult(int requestType, BaseBean result) {
        switch (requestType) {
            case 0:
                setCollect((BeanTourismCollection) result);
                break;
            case 1:
                showToast("收藏成功");
                isCollection = "1";
                ivCollect.setEnabled(true);
                break;
            case 2:
                showToast("取消收藏成功");
                isCollection = "0";
                ivCollect.setEnabled(true);
                break;
            case 3:
                BeanTourDetail beanTourDetail = (BeanTourDetail) result;
                if (beanTourDetail.getData() != null) {
                    url = beanTourDetail.getData().getCover();
                    name = beanTourDetail.getData().getName();
                    content = beanTourDetail.getData().getContent();
                    price = Double.valueOf(beanTourDetail.getData().getPrice());
                    initShare(webUrl + "&shareType=app&code=" + code, name, content, url);
                }
                break;
            case 4:
                setDetailsData((BeanTourDetailData) result);
                break;

        }
    }


    private void setDetailsData(BeanTourDetailData bean) {
        DetailsData = bean.getData();
        if (DetailsData != null && DetailsData.getStock() < 1) {
            TvAppointment.setEnabled(false);
            TvAppointment.setText("已售完");
            TvAppointment.setBackground(mActivity.getResources().getDrawable(R.color.gray_707070));
        }
    }

    @Override
    public void onShowError(String errorMsg, int errorType) {
        super.onShowError(errorMsg, errorType);
        ivCollect.setEnabled(true);
        isCollection = "1";
    }

    /**
     * 查看是否已收藏
     *
     * @param data
     */
    private void setCollect(BeanTourismCollection data) {
        isCollection = data.getData().getStatus();
        mCollectId = data.getData().getId();
        if ("1".equals(data.getData().getStatus())) {
            ivCollect.setImageResource(R.drawable.common_icon_collected);
        } else {
            ivCollect.setImageResource(R.drawable.travel_rv_collect);
        }
    }

    private void initWeb() {
        WebSettings webSettings = mWebView.getSettings();
        if (webSettings == null) return;
        // 支持 Js 使用
        webSettings.setJavaScriptEnabled(true);
        // 开启DOM缓存,默认状态下是不支持LocalStorage的
        webSettings.setDomStorageEnabled(true);
        // 开启数据库缓存
        webSettings.setDatabaseEnabled(true);
        // 支持自动加载图片
        webSettings.setLoadsImagesAutomatically(hasKitkat());
        // 设置 WebView 的缓存模式
        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        // 支持启用缓存模式
        webSettings.setAppCacheEnabled(true);
        // 设置 AppCache 最大缓存值(现在官方已经不提倡使用，已废弃)
//        webSettings.setAppCacheMaxSize(8 * 1024 * 1024);
        // Android 私有缓存存储，如果你不调用setAppCachePath方法，WebView将不会产生这个目录
        webSettings.setAppCachePath(getCacheDir().getAbsolutePath());
        // 数据库路径
//        if (!hasKitkat()) {
//            webSettings.setDatabasePath(getDatabasePath("html").getPath());
//        }
        // 关闭密码保存提醒功能
//        webSettings.setSavePassword(false);
        // 支持缩放
        webSettings.setSupportZoom(true);
        // 设置 UserAgent 属性
        webSettings.setUserAgentString("");
        // 允许加载本地 html 文件/false
        webSettings.setAllowFileAccess(true);
        // 允许通过 file url 加载的 Javascript 读取其他的本地文件,Android 4.1 之前默认是true，在 Android 4.1 及以后默认是false,也就是禁止
        webSettings.setAllowFileAccessFromFileURLs(true);
        // 允许通过 file url 加载的 Javascript 可以访问其他的源，包括其他的文件和 http，https 等其他的源，
        // Android 4.1 之前默认是true，在 Android 4.1 及以后默认是false,也就是禁止
        // 如果此设置是允许，则 setAllowFileAccessFromFileURLs 不起做用
        webSettings.setAllowUniversalAccessFromFileURLs(true);
        mWebView.addJavascriptInterface(new AndroidJs(), "AndroidJs");
        mWebView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return super.shouldOverrideUrlLoading(view, request);
            }
        });
        mWebView.loadUrl(webUrl);
        mWebView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    pbProgress.setVisibility(View.GONE);//加载完网页进度条消失
                } else {
                    pbProgress.setVisibility(View.VISIBLE);//开始加载网页时显示进度条
                    pbProgress.setProgress(newProgress);//设置进度值
                }
            }
        });
    }

    /**
     * 初始化分享
     */
    private void initShare(final String webUrls, final String name, final String content, final String logo) {

        shareManager = new ShareManager(this, new ShareBoardlistener() {
            @Override
            public void onclick(SnsPlatform snsPlatform, SHARE_MEDIA share_media) {
                sharingSuccess();
                if (snsPlatform.mShowWord.equals("生成海报")) {
                    String icon = "";
                    if (TextUtils.isEmpty(posterBackground)) {
                        icon = url;
                    } else {
                        icon = posterBackground;
                    }

                    ARouter.getInstance()
                            .build(Constance.ACTIVITY_URL_POSTERACTIVITY)
                            .withString("url", webUrls)
                            .withString("imageUrl", icon)
                            .navigation();

                } else if (snsPlatform.mShowWord.equals("复制链接")) {
                    copyText();
                } else if (snsPlatform.mShowWord.contains("微信")) {
                    if (!IsAppInstall.isWeixinAvilible(mActivity)) {
                        showToast("亲，您微信还没有安装呢");
                        return;
                    }
                } else if (snsPlatform.mShowWord.contains("QQ")) {
                    if (!IsAppInstall.isQQClientAvailable(mActivity)) {
                        showToast("亲，您QQ还没有安装呢");
                        return;
                    }
                }

                shareManager.showShare(share_media, webUrls, name, content, logo

                        , new CustomShareListener(mActivity) {
                            @Override
                            public void onResult(SHARE_MEDIA platform) {
                                super.onResult(platform);

                                if (platform.name().equals("WEIXIN_FAVORITE")) {

                                    showToast(" 收藏成功啦");

                                } else {
                                    if (platform != SHARE_MEDIA.MORE && platform != SHARE_MEDIA.SMS
                                            && platform != SHARE_MEDIA.EMAIL
                                            && platform != SHARE_MEDIA.FLICKR
                                            && platform != SHARE_MEDIA.FOURSQUARE
                                            && platform != SHARE_MEDIA.TUMBLR
                                            && platform != SHARE_MEDIA.POCKET
                                            && platform != SHARE_MEDIA.PINTEREST

                                            && platform != SHARE_MEDIA.INSTAGRAM
                                            && platform != SHARE_MEDIA.GOOGLEPLUS
                                            && platform != SHARE_MEDIA.YNOTE
                                            && platform != SHARE_MEDIA.EVERNOTE) {
                                        showToast("分享成功啦");
                                    }
                                }

                            }
                        });
            }
        }, "rv_um_share_bill", "rv_um_share_copy");
    }

    /**
     * 与h5交互
     */
    public class AndroidJs {

        @JavascriptInterface
        public String getToken() {
            String token = OkGoUtil.getToken();
            if (TextUtils.isEmpty(token)) {
                ARouter.getInstance().build(Constance.ACTIVITY_URL_LOGINRV).navigation();
            }
            return token;
        }

        @JavascriptInterface
        public void showDialog() {
            mWebView.post(new Runnable() {
                @Override
                public void run() {
                    travelBooking();
                }
            });
        }

        @JavascriptInterface
        public void showButton() {
//            mWebView.post(new Runnable() {
//                @Override
//                public void run() {
//                    llItemBottom.setVisibility(View.VISIBLE);
//                }
//            });

        }


        @JavascriptInterface
        public void hideButton() {

//            mWebView.post(new Runnable() {
//                @Override
//                public void run() {
//                    llItemBottom.setVisibility(View.GONE);
//                }
//            });
        }

        @JavascriptInterface
        public void tourStock(int num) {
//            if (num > 0) {
//                mWebView.post(new Runnable() {
//                    @Override
//                    public void run() {
//
//                    }
//                });
//            } else {
//                mWebView.post(new Runnable() {
//                    @Override
//                    public void run() {
//                        TvAppointment.setEnabled(false);
//                        TvAppointment.setText("已售完");
//                        TvAppointment.setBackground(mActivity.getResources().getDrawable(R.color.gray_707070));
//                    }
//                });
//            }
        }

        @JavascriptInterface
        public void readyOrder(String orderJson) {
//            if (!TextUtil.isEmpty(orderJson)) {
//                beanOrderParam = new Gson().fromJson(orderJson,
//                        new TypeToken<BeanOrderParam>() {
//                        }.getType());
//                if (Integer.valueOf(beanOrderParam.getAdultNum()) < Integer.valueOf(beanOrderParam.getChildNum())) {
//                    showToast("成人数要大于或等于儿童数");
//                } else if (Integer.valueOf(beanOrderParam.getAdultNum()) == 0) {
//                    showToast("成人数不能为空！");
//                } else {
//                    startActivity(TravelerConfirmOrderActivity.getIntent(mActivity, beanOrderParam));
//                }
//
//            }
        }

        @JavascriptInterface
        public void showTop(int state) {
            if (state == 0) {

            } else {

            }
        }
    }

    private void getTourDetail() {
        mPresenter.getData(3, String.format(TourismApi.TOUR_DETAIL, id), BeanTourDetail.class, false);
    }


    /**
     * 屏幕横竖屏切换时避免出现window leak的问题
     */
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        shareManager.close();
    }


    @Override
    public void onResume() {
        super.onResume();
        mWebView.onResume();// 生命周期onResume
    }

    @Override
    protected void onPause() {
        super.onPause();
        mWebView.onPause();//生命周期onPause
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        UMShareAPI.get(this).release();
        mWebView.stopLoading();// 停止当前加载
        mWebView.clearMatches();// 清除网页查找的高亮匹配字符。
        mWebView.clearHistory();// 清除当前 WebView 访问的历史记录
        mWebView.clearSslPreferences();//清除ssl信息
        mWebView.clearCache(true);//清空网页访问留下的缓存数据。需要注意的时，由于缓存是全局的，所以只要是WebView用到的缓存都会被清空，即便其他地方也会使用到。该方法接受一个参数，从命名即可看出作用。若设为false，则只清空内存里的资源缓存，而不清空磁盘里的。
        mWebView.loadUrl("about:blank");// 清空当前加载
        mWebView.removeAllViews();// 清空子 View
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
            mWebView.removeJavascriptInterface("AndroidNative");// 向 Web端注入 java 对象
        }
        mWebView.destroy();// 生命周期销毁

    }

    private class AddCollection {
        private String typeId;
        private String type;

        public AddCollection(String typeId, String type) {
            this.typeId = typeId;
            this.type = type;
        }

        public String getTypeId() {
            return typeId;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    private class CancelCollection {
        private String id;
        private String status;

        public CancelCollection(String id, String status) {
            this.id = id;
            this.status = status;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }


    /**
     * 复制文本
     */
    private void copyText() {
        if (myClipboard == null) {
            myClipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);
        }
        String code = Cookie.getStringValue(getApplicationContext(), SPConstance.USER_JSON_CODE, "");
        ClipData myClip = ClipData.newPlainText("text", webUrl + "&shareType=app&code=" + code);
        myClipboard.setPrimaryClip(myClip);
        showToast("复制成功！");
    }


    /**
     * 分享积分
     */
    private void sharingSuccess() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            BeanUserInfo.UserInfo userInfo = getUserInfo();
            if (userInfo != null) {
                Map<String, Object> headMap = new LinkedHashMap<>();
                headMap.put("Content-type", "application/json;charset=UTF-8");
                mPresenter.postBodyData(RvFrameConfig.HOST, 20, CommonApi.TOUR_SENDMESSAGE, BaseBean.class, new SharingSuccess("SHARE", userInfo.getUserid()), headMap, false);
            }
        }
    }

    private class SharingSuccess {
        private String integralRuleCode;
        private int userId;

        public SharingSuccess(String integralRuleCode, int userId) {
            this.integralRuleCode = integralRuleCode;
            this.userId = userId;
        }

        public String getIntegralRuleCode() {
            return integralRuleCode;
        }

        public void setIntegralRuleCode(String integralRuleCode) {
            this.integralRuleCode = integralRuleCode;
        }

        public int getUserId() {
            return userId;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }
    }


}
