package com.rv.rvmine.traveler;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.main.home.DrivingListActivity;
import com.rv.rvmine.R;
import com.rv.rvmine.R2;

import butterknife.OnClick;

/**
 * 出游设置
 */
public class TravelSettingsActivity extends BaseStatusActivity<CommonPresenter> {

    @Override
    protected int setLayout() {
        return R.layout.activity_travel_settings;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("出游设置");
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }

    @OnClick({R2.id.rl_item_driver, R2.id.rl_item_traveler})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.rl_item_driver){
            startActivity(new Intent(mActivity, DrivingListActivity.class));
        }else if (id == R.id.rl_item_traveler){
            startActivity(new Intent(mActivity, ChooseAVisitorActivity.class));
        }
    }
}
