package com.rv.home.rv.module.ui.login;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.rv.home.R;
import com.rv.home.R2;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.listener.TextChangedListener;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.home.rv.module.basic.BaseLoginActivity;
import com.ruiwenliu.wrapper.bean.BeanUserInfo;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.home.rv.module.ui.login.bean.RegisteredBean;
import com.umeng.socialize.bean.SHARE_MEDIA;

import java.util.Map;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * Created :Auser
 * Date: 2019/5/21.
 * Desc:确认密码
 */
public class ConfirmPwdActivity extends BaseLoginActivity<CommonPresenter> {

    @BindView(R2.id.et_pwd)
    EditText etPwd;
    @BindView(R2.id.iv_clear_pwd)
    ImageView ivClearPwd;
    @BindView(R2.id.et_again_pwd)
    EditText etAgainPwd;
    @BindView(R2.id.iv_clear_again_pwd)
    ImageView ivClearAgainPwd;
    @BindView(R2.id.cb_annotations)
    CheckBox cbAnnotations;
    @BindView(R2.id.tv_agreement)
    TextView tvAgreement;
    @BindView(R2.id.tv_registered)
    TextView tvRegistered;
    private String mOpenid;
    private String mHeadImg;
    private String mName;
    private int mIsQQ;
    private String mPhone;
    private String mCode;
    private String mUnionid;

    private boolean pwdShow;//密码
    private boolean confirmShow;//确认密码
    public static Intent getIntent(Context context, String openid, String headImg, int isQQ, String name, String phone, String code, String uid) {
        return new Intent(context, ConfirmPwdActivity.class)
                .putExtra("openid", openid)
                .putExtra("headImg", headImg)
                .putExtra("isQQ", isQQ)
                .putExtra("name", name)
                .putExtra("phone", phone)
                .putExtra("code", code)
                .putExtra("uid", uid);
    }


    @Override
    protected int setLayout() {
        return R.layout.rv_act_confirm_pwd;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        super.initView(savedInstanceState, titleView, intent);
        titleView.setTitle(mActivity.getString(R.string.rv_edit_pwd));
        editListener(etPwd);
        editListener(etAgainPwd);
        mOpenid = intent.getStringExtra("openid");
        mHeadImg = intent.getStringExtra("headImg");
        mName = intent.getStringExtra("name");
        mIsQQ = intent.getIntExtra("isQQ", 1);
        mCode = intent.getStringExtra("code");
        mPhone = intent.getStringExtra("phone");
        mUnionid=intent.getStringExtra("uid");
    }


    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {

    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 2) {
            processLoginData((RegisteredBean) result);
        }else if (requestType == 10){
                setDataUser((BeanUserInfo)result);
        }
    }

    @Override
    public void onComplete(SHARE_MEDIA share_media, int i, Map<String, String> map) {

    }


    /**
     * 获得输入密码
     *
     * @return
     */
    private String getPwd() {
        return etPwd.getText().toString().trim();
    }

    ;

    /**
     * 获得再次输入密码
     *
     * @return
     */
    private String getAgainPwd() {
        return etPwd.getText().toString().trim();
    }

    ;

    /**
     * 清除编辑数据
     */
    private void clearEditData(EditText text) {
        text.setText("");
    }

    @OnClick({R2.id.iv_clear_pwd, R2.id.iv_clear_again_pwd, R2.id.tv_agreement, R2.id.tv_registered})
    public void onViewClicked(View view) {
        if(view.getId()==R.id.iv_clear_pwd){
            pwdShow=!pwdShow;
            ivClearPwd.setSelected(pwdShow);
            etPwd.setTransformationMethod(pwdShow? HideReturnsTransformationMethod.getInstance(): PasswordTransformationMethod.getInstance());
        }else if(view.getId()==R.id.iv_clear_again_pwd){
            confirmShow=!confirmShow;
            ivClearAgainPwd.setSelected(confirmShow);
            etAgainPwd.setTransformationMethod(confirmShow? HideReturnsTransformationMethod.getInstance(): PasswordTransformationMethod.getInstance());
        }
        else if(view.getId()==R.id.tv_agreement){

        }
        else if(view.getId()==R.id.tv_registered){
            if (getPwd().length() < 8) {
                showToast(mActivity.getString(R.string.rv_pwd_length));
                return;
            }
            if (!getPwd().equals(getAgainPwd())) {
                showToast(mActivity.getString(R.string.rv_pwd_same));
                return;
            }
            if (cbAnnotations.isChecked() == false) {
                showToast(mActivity.getString(R.string.rv_confirm_agreement));
                return;
            }
            otherLoginBind(mPhone, mCode, getPwd(), mName, mHeadImg, mOpenid, 2, mIsQQ,mUnionid);
        }
    }

    /**
     * 文本输入监听
     *
     * @param editText
     */
    private void editListener(final EditText editText) {
        editText.addTextChangedListener(new TextChangedListener() {
            @Override
            public void afterTextChanged(Editable s) {
                super.afterTextChanged(s);
//                switch (editText.getId()) {
//
//                    case R.id.et_pwd:
//                        ivClearPwd.setVisibility(getPwd().length() > 0 ? View.VISIBLE : View.GONE);
//                        break;
//                    case R.id.et_again_pwd:
//                        ivClearAgainPwd.setVisibility(getAgainPwd().length() > 0 ? View.VISIBLE : View.GONE);
//                        break;
//                }
                if (etPwd.length() > 0 && etAgainPwd.length() > 0) {
                    tvRegistered.setEnabled(true);
                    tvRegistered.setSelected(true);
                } else {
                    tvRegistered.setEnabled(false);
                    tvRegistered.setSelected(false);
                }
            }
        });
    }
}
