package com.ruiwenliu.wrapper.http;

import android.text.TextUtils;

import com.ruiwenliu.wrapper.util.LogUtils;
import com.rv.component.utils.LogUtil;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;

import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class RvLogInterceptor implements Interceptor {
    private final String TAG = "http";

    @Override
    public Response intercept(Chain chain) throws IOException {

        Request request = chain.request();
        LogUtil.d("http:url=", request.url().toString());
        LogUtil.d("http:请求方法=", request.method());
        LogUtil.d("http:headers=", "  ");
        Headers headers = request.headers();
        if (headers != null) {
            Set<String> names = headers.names();
            if (names != null) {
                for (String s : names) {
                    LogUtil.d("http:headers=", s + "=" + headers.get(s));
                }
            }
        }
        Response response = chain.proceed(chain.request());

        BufferedSource source = response.body().source();
        Buffer buffer = source.buffer();
        Charset UTF8 = Charset.forName("UTF-8");
        String bodyStr = buffer.clone().readString(UTF8);

        LogUtil.d("http:response=", bodyStr);

        return response;
    }
}
