package com.ruiwenliu.wrapper.base;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Window;


import com.alibaba.android.arouter.launcher.ARouter;
import com.base.utils.tools.android.NetworkUtil;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.R;
import com.ruiwenliu.wrapper.dialog.LoadingDialog;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.presenter.WrapperPresenter;
import com.ruiwenliu.wrapper.receiver.NetWorkReceiver;

import java.lang.reflect.ParameterizedType;

/**
 * Created by ruiwen
 * Data:2018/7/3 0003
 * Email:1054750389@qq.com
 * Desc:网络层初始化
 */

public abstract class BaseActivity<P extends MvpPresenter> extends BaseWrapperActivity implements BaseView, NetWorkReceiver.NetChangListener {
    protected P mPresenter;
    private LoadingDialog mLoadingDialog;
    private boolean isLoadData = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ParameterizedType type = (ParameterizedType) this.getClass().getGenericSuperclass();
        Class<? extends WrapperPresenter> presenterClass = (Class<? extends WrapperPresenter>) type.getActualTypeArguments()[0];
        try {
            this.mPresenter = (P) presenterClass.newInstance();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
        mPresenter.attachView(this);
        mLoadingDialog = createLoadingDialog();
        if (NetworkUtil.isNetworkAvailable(mActivity)) {
            isLoadData = true;
            loadData(savedInstanceState, getIntent());
        }
        NetWorkReceiver.getInstance().register(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        NetWorkReceiver.getInstance().unRegister(this);
        onHideLoading();
        mLoadingDialog = null;
        mPresenter.detachView();
        mPresenter = null;
    }

    @Override
    public void onShowLoading() {
        if (!isFinishing() && mLoadingDialog != null && !mLoadingDialog.isShowing()) {
            mLoadingDialog.show();
        }
    }

    @Override
    public void onHideLoading() {
        if (!isFinishing() && mLoadingDialog != null && mLoadingDialog.isShowing()) {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mLoadingDialog.dismiss();
                }
            });
        }
    }

    @Override
    public void onBeforeSuccess() {

    }


    @Override
    public void onShowError(String errorMsg, int errorType) {
        if (!NetworkUtil.isNetworkAvailable(getApplicationContext())) {
            showToast("网络异常，请检查您的网络");
            return;
        }
        if (!TextUtils.isEmpty(errorMsg)) {
            showToast(errorMsg);
        }
    }

    @Override
    public void onErrorToken() {
        ARouter.getInstance().build(Constance.ACTIVITY_URL_LOGINRV).navigation();
    }

    protected LoadingDialog createLoadingDialog() {
        if (mLoadingDialog == null) {
            mLoadingDialog = new LoadingDialog(this, R.style.Alert_Dialog_Style);
            mLoadingDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
            mLoadingDialog.setCanceledOnTouchOutside(false);
            mLoadingDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        }
        return mLoadingDialog;
    }

    /**
     * 从intent中获取请求参数，初始化vo对象，并发送请求
     *
     * @param savedInstanceState
     * @param intent
     */
    protected abstract void loadData(Bundle savedInstanceState, Intent intent);

    @Override
    public void netAvailable() {
        if (!isLoadData) {
            loadData(null, getIntent());
            isLoadData = true;
        }
    }

    @Override
    public void netUnAvailable() {

    }
}

