package com.xxfc.rv;

import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;

import com.ruiwenliu.wrapper.SPConstance;
import com.ruiwenliu.wrapper.base.BaseActivity;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.util.UtilsManager;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.rv.component.utils.CacheEnum;
import com.rv.component.utils.Cookie;
import com.rv.component.utils.DateUtils;
import com.rv.component.utils.LogUtil;
import com.ruiwenliu.wrapper.base.presenter.CommonPresenter;
import com.rv.component.utils.RvCache;
import com.rv.im.AppConfig;
import com.rv.im.bean.ImConfig;
import com.rv.im.bean.ImConfigBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.concurrent.TimeUnit;

import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class WelcomeActivity extends BaseActivity<CommonPresenter> {
    private Disposable mDisposable = null;

    @Override
    public void onShowResult(int requestType, BaseBean result) {
        if (requestType == 0) {
            ImConfigBean bean = (ImConfigBean) result;
            ImConfig config;
            if (bean != null && bean.resultCode == 1 && ((ImConfigBean) result).getData() != null) {
                LogUtil.e("zq", "获取网络配置成功，使用服务端返回的配置并更新本地配置");
                config = bean.getData();
                AppConfig appConfig = AppConfig.initConfig(config);
                RvCache.getInstance(mActivity).save(appConfig, CacheEnum.IM_CONFIG);
            }
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.rv_act_weclome;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);//隐藏菜单栏
        interval();

        LogUtil.d("start");
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        mPresenter.saveOnclick("8", "");
        getImConfig();
    }

    private void getImConfig() {
        mPresenter.getData(0, AppConfig.CONFIG_URL, ImConfigBean.class, false);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        stopCarousel();
    }

    /**
     * 计时器
     */
    private void interval() {
        mDisposable = Flowable.interval(2, TimeUnit.SECONDS)
                .doOnNext(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) throws Exception {
                    }
                })
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(new Consumer<Long>() {
                    @Override
                    public void accept(@NonNull Long aLong) {
                        try {
                            String token = Cookie.getStringValue(getApplicationContext(), SPConstance.USER_JSON_TOKEN, "");
                            String tokenTime = Cookie.getStringValue(getApplicationContext(), SPConstance.USER_JSON_TOKE_TIME, "");
                            if (!TextUtils.isEmpty(token)) {
                                OkGoUtil.setToken(token, tokenTime);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        SharedPreferences preferences = getSharedPreferences("first_open", MODE_PRIVATE);
                        if (preferences.getBoolean("first", true)) {
                            preferences.edit().putBoolean("first", false).commit();
                            startActivity(GuideActivity.getIntent(mActivity));
                        } else {
                            startActivity(MainActivity.getIntent(mActivity));
                        }
                        mDisposable.dispose();
                        finish();
                    }
                });

    }

    /**
     * 停止计时
     */
    public void stopCarousel() {
        if (mDisposable != null && !mDisposable.isDisposed()) {
            mDisposable.dispose();
        }
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        this.getWindow().getDecorView().setBackground(null);
        if (Build.VERSION.SDK_INT >= 21) {
            getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_HIDE_NAVIGATION | View.SYSTEM_UI_FLAG_FULLSCREEN);
        }
//        if (Build.VERSION.SDK_INT >= 21) {
//            View decorView = getWindow().getDecorView();
//            int option = View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
//                    | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
//                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE;
//            decorView.setSystemUiVisibility(option);
//            getWindow().setNavigationBarColor(Color.TRANSPARENT);
//            getWindow().setStatusBarColor(Color.TRANSPARENT);
//        }
    }
}
