/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.search.route;

import com.baidu.mapapi.search.route.PlanNode;

public class MassTransitRoutePlanOption {
    public PlanNode mFrom = null;
    public PlanNode mTo = null;
    public String mCoordType = "bd09ll";
    public TacticsIncity mTacticsIncity = TacticsIncity.ETRANS_SUGGEST;
    public TacticsIntercity mTacticsIntercity = TacticsIntercity.ETRANS_LEAST_TIME;
    public TransTypeIntercity mTransTypeIntercity = TransTypeIntercity.ETRANS_TRAIN_FIRST;
    public int mPageSize = 10;
    public int mPageIndex = 1;

    public MassTransitRoutePlanOption from(PlanNode planNode) {
        this.mFrom = planNode;
        return this;
    }

    public MassTransitRoutePlanOption to(PlanNode planNode) {
        this.mTo = planNode;
        return this;
    }

    @Deprecated
    public MassTransitRoutePlanOption coordType(String string) {
        this.mCoordType = string;
        return this;
    }

    public MassTransitRoutePlanOption tacticsIncity(TacticsIncity tacticsIncity) {
        this.mTacticsIncity = tacticsIncity;
        return this;
    }

    public MassTransitRoutePlanOption tacticsIntercity(TacticsIntercity tacticsIntercity) {
        this.mTacticsIntercity = tacticsIntercity;
        return this;
    }

    public MassTransitRoutePlanOption transtypeintercity(TransTypeIntercity transTypeIntercity) {
        this.mTransTypeIntercity = transTypeIntercity;
        return this;
    }

    public MassTransitRoutePlanOption pageSize(int n2) {
        if (n2 >= 1 && n2 <= 10) {
            this.mPageSize = n2;
        }
        return this;
    }

    public MassTransitRoutePlanOption pageIndex(int n2) {
        if (n2 >= 0 && n2 <= 0x7FFFFFFE) {
            this.mPageIndex = n2 + 1;
        }
        return this;
    }

    public static enum TransTypeIntercity {
        ETRANS_TRAIN_FIRST(0),
        ETRANS_PLANE_FIRST(1),
        ETRANS_COACH_FIRST(2);

        private int a = 0;

        private TransTypeIntercity(int n3) {
            this.a = n3;
        }

        public int getInt() {
            return this.a;
        }
    }

    public static enum TacticsIntercity {
        ETRANS_LEAST_TIME(0),
        ETRANS_START_EARLY(1),
        ETRANS_LEAST_PRICE(2);

        private int a = 0;

        private TacticsIntercity(int n3) {
            this.a = n3;
        }

        public int getInt() {
            return this.a;
        }
    }

    public static enum TacticsIncity {
        ETRANS_SUGGEST(0),
        ETRANS_LEAST_TRANSFER(1),
        ETRANS_LEAST_WALK(2),
        ETRANS_NO_SUBWAY(3),
        ETRANS_LEAST_TIME(4),
        ETRANS_SUBWAY_FIRST(5);

        private int a = 0;

        private TacticsIncity(int n3) {
            this.a = n3;
        }

        public int getInt() {
            return this.a;
        }
    }
}

