package com.xxrv.wallet.adapter;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.base.utils.ui.image.round.RoundImageView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.ruiwenliu.wrapper.util.glide.GlideManager;
import com.rv.component.utils.DateUtils;
import com.xxrv.wallet.R;
import com.xxrv.wallet.bean.IncomeRecordsBean;

import java.util.List;

public class IncomeListAdapter extends BaseQuickAdapter<IncomeRecordsBean.IncomeItem, BaseViewHolder> {

    public IncomeListAdapter(@Nullable List<IncomeRecordsBean.IncomeItem> data) {
        super(R.layout.item_commision, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, IncomeRecordsBean.IncomeItem item) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(dealName(item.getUsername())).append("成交").append(item.getPrice()).append("元");
        helper.setText(R.id.tv_consume_name, buffer.toString());

        helper.setText(R.id.tv_income_time, DateUtils.timestampToString1(item.getCrtTime()));

        if (item.getWaiting() == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("+").append(item.getCommission()).append("元");
            helper.setText(R.id.tv_amount, builder.toString());
        } else {
            helper.setText(R.id.tv_amount, "进行中");
        }
    }

    private String dealName(String name) {
        if (!TextUtils.isEmpty(name)) {
            if (name.length() == 11) {
                return name.substring(0, 3) + "****" + name.substring(7, name.length());
            }
        }
        return name;
    }
}
