package com.xxrv.wallet.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.frame.base.url.Constance;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.presenter.WalletPresenter;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * 钱包
 */
@Route(path = Constance.ACTIVITY_URL_WALLET)
public class WalletActivity extends BaseStatusActivity<WalletPresenter> {

    @BindView(R2.id.tv_wallet_balance)
    TextView tvWalletBalance;
    @BindView(R2.id.tv_today_amount)
    TextView tvTodayAmount;
    @BindView(R2.id.tv_total_amount)
    TextView tvTotalAmount;
    @BindView(R2.id.tv_not_amount)
    TextView tvNotAmount;

    @Override
    protected int setLayout() {
        return R.layout.activity_wallet;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        showTitle(false);
    }

    @Override
    public void onShowResult(int requestType, BaseBean result) {

    }


    @OnClick({R2.id.iv_back, R2.id.tv_item_withdraw, R2.id.rl_item_consumer_details, R2.id.rl_item_commission_record, R2.id.rl_item_withdrawals_record})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.iv_back) {
            finish();
        } else if (id == R.id.tv_item_withdraw) {
            //提现

        } else if (id == R.id.rl_item_consumer_details) {
            startActivity(new Intent(getApplicationContext(), ConsumeDetailActivity.class));
            //消费明细
        } else if (id == R.id.rl_item_commission_record) {
            //佣金记录
            startActivity(new Intent(getApplicationContext(), CommissionDetailActivity.class));
        } else if (id == R.id.rl_item_withdrawals_record) {
            //提现记录

        }
    }
}
