package com.xxrv.wallet.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.frame.rv.config.RvFrameConfig;
import com.ruiwenliu.wrapper.base.BaseBean;
import com.ruiwenliu.wrapper.base.BaseStatusActivity;
import com.ruiwenliu.wrapper.presenter.MvpPresenter;
import com.ruiwenliu.wrapper.weight.TitleView;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshLayout;
import com.ruiwenliu.wrapper.weight.refresh.SimpleRefreshView;
import com.rv.home.rv.module.ApiConfig;
import com.rv.home.rv.module.basic.presenter.CommonPresenter;
import com.xxrv.wallet.R;
import com.xxrv.wallet.R2;
import com.xxrv.wallet.adapter.ConsumeListAdapter;
import com.xxrv.wallet.bean.ConsumeListBean;
import com.yuyife.okgo.OkGoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import butterknife.BindView;

public class ConsumeDetailActivity extends BaseStatusActivity<CommonPresenter> implements BaseQuickAdapter.RequestLoadMoreListener, SimpleRefreshLayout.OnSimpleRefreshListener {

    @BindView(R2.id.recyclerView)
    RecyclerView recyclerView;
    @BindView(R2.id.refresh)
    SimpleRefreshLayout refreshLayout;
    private int currentPage = 1;
    private int pageSize = 20;
    private int pageTotal;

    private ConsumeListAdapter adapter;

    @Override
    public void onShowResult(int requestType, BaseBean result) {

        if (requestType == 0) {
            ConsumeListBean bean = (ConsumeListBean) result;
            if (bean != null && bean.isRel() && bean.getData() != null) {
                if (currentPage == 1) {
                    pageTotal = bean.getData().getTotalPage();
                    refreshLayout.onRefreshComplete();
                    if (bean.getData().getData().size() == 0) {
                        adapter.setEmptyView(getEmptyView(recyclerView, -1, getString(R.string.rv_select_not_data)));
                        adapter.notifyDataSetChanged();
                    } else {
                        adapter.setNewData(bean.getData().getData());
                    }
                } else {
                    adapter.addData(bean.getData().getData());
                    adapter.loadMoreComplete();
                }
            }
        }
    }

    @Override
    protected int setLayout() {
        return R.layout.activity_consume_detail;
    }

    @Override
    protected void initView(Bundle savedInstanceState, TitleView titleView, Intent intent) {
        titleView.setTitle("消费明细");
        recyclerView.setLayoutManager(new LinearLayoutManager(this, LinearLayout.VERTICAL, false));
        adapter = new ConsumeListAdapter(new ArrayList<ConsumeListBean.ConsumeItem>());
        adapter.setOnLoadMoreListener(this, recyclerView);
        refreshLayout.setHeaderView(new SimpleRefreshView(this));
        refreshLayout.setOnSimpleRefreshListener(this);
        recyclerView.setAdapter(adapter);
    }

    @Override
    protected void loadData(Bundle savedInstanceState, Intent intent) {
        super.loadData(savedInstanceState, intent);
        getConsumeData();
    }

    private void getConsumeData() {
        if (!TextUtils.isEmpty(OkGoUtil.getToken())) {
            Map<String, Object> header = new HashMap<>();
            header.put("Authorization", OkGoUtil.getToken());

            Map<String, Object> map = new HashMap<>();
            map.put("pageNo", currentPage);
            map.put("pageSize", pageSize);

            mPresenter.getData(RvFrameConfig.HOST, 0, ApiConfig.HTTP_URL_CONSUME_LIST, ConsumeListBean.class, map, header, true);
        }
    }

    @Override
    public void onLoadMoreRequested() {
        if (currentPage >= pageTotal) {
            adapter.loadMoreEnd();
        } else {
            currentPage++;
            getConsumeData();
        }
    }

    @Override
    public void onRefresh() {
        currentPage = 1;
        getConsumeData();
    }
}
