package com.rv.version.util;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.util.Log;
import android.widget.Toast;


import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadLargeFileListener;
import com.liulishuo.filedownloader.FileDownloader;

import java.io.File;

public class DownloadAppUtils {

    private static final String TAG = DownloadAppUtils.class.getSimpleName();
    public static String downloadUpdateApkFilePath;//下载更新Apk 文件路径


    public static void download(final Context context, String url, final String serverVersionName) {

        String packageName = context.getPackageName();
        String rootPath = null;
        rootPath = getCachePath(context) + File.separator + Environment.DIRECTORY_DOWNLOADS + File.separator;
        send(context, -1, serverVersionName);
        File file = new File(rootPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String apkLocalPath = rootPath + "app_" + serverVersionName + ".apk";
        downloadUpdateApkFilePath = apkLocalPath;
        FileDownloader.setup(context);
        FileDownloader.getImpl().create(url)
                .setPath(apkLocalPath)
                .setListener(new FileDownloadLargeFileListener() {
                    @Override
                    protected void pending(BaseDownloadTask task, long soFarBytes, long totalBytes) {
                        Log.e(TAG, "pending");
                    }

                    @Override
                    protected void progress(BaseDownloadTask task, long soFarBytes, long totalBytes) {
                        send(context, (int) (soFarBytes * 100.0 / totalBytes), serverVersionName);
                    }

                    @Override
                    protected void paused(BaseDownloadTask task, long soFarBytes, long totalBytes) {
                        Log.e(TAG, "paused");
                    }

                    @Override
                    protected void completed(BaseDownloadTask task) {
                        send(context, 100, serverVersionName);
                    }

                    @Override
                    protected void error(BaseDownloadTask task, Throwable e) {
                        Toast.makeText(context, "下载出错", Toast.LENGTH_SHORT).show();
                    }

                    @Override
                    protected void warn(BaseDownloadTask task) {
                        Log.e(TAG, "warn");
                    }
                }).start();
    }


    private static void send(Context context, int progress, String serverVersionName) {
        Intent intent = new Intent("teprinciple.update");
        intent.putExtra("progress", progress);
        intent.putExtra("title", serverVersionName);
        context.sendBroadcast(intent);
    }

    private static String getCachePath(Context context) {
        String cachePath = null;
        if (Environment.MEDIA_MOUNTED.equals(Environment.getExternalStorageState())
                || !Environment.isExternalStorageRemovable()) {
            cachePath = context.getExternalCacheDir().getPath();
        } else {
            cachePath = context.getCacheDir().getPath();
        }
        return cachePath;
    }
}
