package com.rv.share.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import android.widget.TextView;

import com.rv.component.utils.DisplayUtil;
import com.rv.share.R;

/*****
 *
 * 分享选择框
 */
public class ShareChoiceDialog implements View.OnClickListener {

    private Context mContext;

    private BottomSheetDialog dialog;
    private TextView tvCopy;
    private TextView tvWx;
    private TextView tvWXC;
    private TextView tvQQ;
    private TextView tvBill;
    private TextView tvCancle;

    private ShareListener listener;
    private boolean isShowCopy = false;
    private boolean isShowBill = false;
    private boolean isShowWx = false;
    private boolean isShowWxC = false;
    private boolean isShowQQ = false;
    private int drawableSize = 50;

    private ShareChoiceDialog(Context context) {
        mContext = context;
        dialog = new BottomSheetDialog(context);
    }

    private void create() {
        View view = View.inflate(mContext, R.layout.dialog_share_choice, null);
        tvCopy = view.findViewById(R.id.tv_copy);
        tvWx = view.findViewById(R.id.tv_weixin);
        tvWXC = view.findViewById(R.id.tv_weixin_circle);
        tvQQ = view.findViewById(R.id.tv_qq);
        tvBill = view.findViewById(R.id.tv_bill);
        tvCancle = view.findViewById(R.id.tv_cancel);
        if (isShowCopy) {
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_share_copy);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, drawableSize), DisplayUtil.dip2px(mContext, drawableSize));
            tvCopy.setCompoundDrawables(null, drawable, null, null);
            tvCopy.setVisibility(View.VISIBLE);
        }
        if (isShowWx) {
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_share_wx);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, drawableSize), DisplayUtil.dip2px(mContext, drawableSize));
            tvWx.setCompoundDrawables(null, drawable, null, null);
            tvWx.setVisibility(View.VISIBLE);
        }
        if (isShowWxC) {
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_share_cir);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, drawableSize), DisplayUtil.dip2px(mContext, drawableSize));
            tvWXC.setCompoundDrawables(null, drawable, null, null);
            tvWXC.setVisibility(View.VISIBLE);
        }
        if (isShowQQ) {
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_share_qq);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, drawableSize), DisplayUtil.dip2px(mContext, drawableSize));
            tvQQ.setCompoundDrawables(null, drawable, null, null);
            tvQQ.setVisibility(View.VISIBLE);
        }
        if (isShowBill) {
            Drawable drawable = mContext.getResources().getDrawable(R.drawable.icon_share_bill);
            drawable.setBounds(0, 0, DisplayUtil.dip2px(mContext, drawableSize), DisplayUtil.dip2px(mContext, drawableSize));
            tvBill.setCompoundDrawables(null, drawable, null, null);
            tvBill.setVisibility(View.VISIBLE);
        }

        tvCopy.setOnClickListener(this);
        tvWx.setOnClickListener(this);
        tvWXC.setOnClickListener(this);
        tvQQ.setOnClickListener(this);
        tvBill.setOnClickListener(this);
        tvCancle.setOnClickListener(this);
        dialog.setContentView(view);
        dialog.setCancelable(false);
    }

    public void show() {
        dialog.show();
    }


    @Override
    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.tv_copy) {
            if (listener != null) {
                listener.copyShare();
            }
        } else if (i == R.id.tv_weixin) {
            if (listener != null) {
                listener.wxShare();
            }
        } else if (i == R.id.tv_weixin_circle) {
            if (listener != null) {
                listener.wxCShare();
            }
        } else if (i == R.id.tv_qq) {
            if (listener != null) {
                listener.qqShare();
            }
        } else if (i == R.id.tv_bill) {
            if (listener != null) {
                listener.billShare();
            }
        } else if (i == R.id.tv_cancel) {
            dialog.dismiss();
        }
        dialog.dismiss();
    }


    public static class Builder {
        private ShareChoiceDialog dialog;

        public Builder(Context context) {
            dialog = new ShareChoiceDialog(context);
        }

        public Builder setShareListener(ShareListener listener) {
            dialog.listener = listener;
            return this;
        }

        public Builder setCopyVisiable(boolean b) {
            dialog.isShowCopy = b;
            return this;
        }

        public Builder setBillVisiable(boolean b) {
            dialog.isShowBill = b;
            return this;
        }

        public Builder setWxVisiable(boolean b) {
            dialog.isShowWx = b;
            return this;
        }

        public Builder setWxCVisiable(boolean b) {
            dialog.isShowWxC = b;
            return this;
        }

        public Builder setQQVisiable(boolean b) {
            dialog.isShowQQ = b;
            return this;
        }

        public ShareChoiceDialog create() {
            dialog.create();
            return dialog;
        }
    }

    public interface ShareListener {

        /****
         * 复制链接
         */
        void copyShare();

        /****
         * 微信分享
         */
        void wxShare();

        /*****
         * 朋友圈分享
         */
        void wxCShare();

        /*****
         * qq分享
         */
        void qqShare();

        /****
         * 生成海报
         */
        void billShare();

        /*****
         * 取消
         */
        void close();
    }

}
